/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.restfulie.relation;

import br.com.caelum.vraptor.core.Routes;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.SuperMethod;
import br.com.caelum.vraptor.restfulie.relation.ControllerBasedRelation;
import br.com.caelum.vraptor.restfulie.relation.Relation;
import br.com.caelum.vraptor.restfulie.relation.RelationBuilder;
import br.com.caelum.vraptor.restfulie.relation.UriBasedRelation;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRelationBuilder
implements RelationBuilder {
    private final String name;
    private Class<?> controller;
    private final Routes routes;
    private final Proxifier proxifier;
    private Method method;
    private Object[] parameters = new Object[0];
    private String customUri;

    public DefaultRelationBuilder(String name, Routes routes, Proxifier proxifier) {
        this.name = name;
        this.routes = routes;
        this.proxifier = proxifier;
    }

    @Override
    public <T> T uses(Class<T> type) {
        this.controller = type;
        return type.cast(this.proxifier.proxify(type, new Callback()));
    }

    @Override
    public RelationBuilder at(String uri) {
        this.customUri = uri;
        return this;
    }

    @Override
    public Relation build() {
        if (this.customUri != null) {
            return new UriBasedRelation(this.name, this.customUri);
        }
        if (this.controller != null) {
            if (this.method == null) {
                this.method = this.findMethod(this.name, this.controller);
                this.parameters = new Object[this.method.getParameterTypes().length];
            }
            return new ControllerBasedRelation(this.controller, this.name, this.method, this.parameters, this.routes);
        }
        throw new IllegalStateException("Relation was not correctly created: '" + this.name + "'");
    }

    private Method findMethod(String name, Class<?> type) {
        if (type.equals(Object.class)) {
            throw new IllegalArgumentException("Controller " + this.controller.getName() + " does not have a method named " + name);
        }
        for (Method m : type.getDeclaredMethods()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return this.findMethod(name, type.getSuperclass());
    }

    static /* synthetic */ Object[] access$102(DefaultRelationBuilder x0, Object[] x1) {
        x0.parameters = x1;
        return x1;
    }

    class Callback
    implements MethodInvocation {
        Callback() {
        }

        public Object intercept(Object proxy, Method method, Object[] args, SuperMethod superMethod) {
            DefaultRelationBuilder.this.method = method;
            DefaultRelationBuilder.access$102(DefaultRelationBuilder.this, args);
            return null;
        }
    }
}

