/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.restfulie.serialization;

import br.com.caelum.vraptor.config.Configuration;
import br.com.caelum.vraptor.restfulie.Restfulie;
import br.com.caelum.vraptor.restfulie.hypermedia.HypermediaResource;
import br.com.caelum.vraptor.restfulie.relation.Relation;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class LinkConverter
implements Converter {
    private final Restfulie restfulie;
    private final Converter base;
    private final Configuration config;

    public LinkConverter(Converter base, Restfulie restfulie, Configuration config) {
        this.base = base;
        this.restfulie = restfulie;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object root, HierarchicalStreamWriter writer, MarshallingContext context) {
        this.base.marshal(root, writer, context);
        HypermediaResource resource = (HypermediaResource)root;
        try {
            for (Relation t : resource.getRelations(this.restfulie)) {
                writer.startNode("atom:link");
                writer.addAttribute("rel", t.getName());
                writer.addAttribute("href", this.config.getApplicationPath() + t.getUri());
                writer.addAttribute("xmlns:atom", "http://www.w3.org/2005/Atom");
                writer.endNode();
            }
        }
        finally {
            this.restfulie.clear();
        }
    }

    public Object unmarshal(HierarchicalStreamReader arg0, UnmarshallingContext arg1) {
        return this.base.unmarshal(arg0, arg1);
    }

    public boolean canConvert(Class type) {
        return HypermediaResource.class.isAssignableFrom(type) && this.base.canConvert(type);
    }
}

