/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization;

import br.com.caelum.vraptor.http.FormatResolver;
import br.com.caelum.vraptor.restfulie.RestHeadersHandler;
import br.com.caelum.vraptor.restfulie.hypermedia.HypermediaResource;
import br.com.caelum.vraptor.serialization.IgnoringSerializer;
import br.com.caelum.vraptor.serialization.RepresentationResult;
import br.com.caelum.vraptor.serialization.Serialization;
import br.com.caelum.vraptor.serialization.Serializer;
import br.com.caelum.vraptor.view.PageResult;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepresentationResult
implements RepresentationResult {
    private final FormatResolver formatResolver;
    private List<Serialization> serializations;
    private final PageResult result;
    private final RestHeadersHandler headersHandler;

    public DefaultRepresentationResult(FormatResolver formatResolver, PageResult result, List<Serialization> serializations, RestHeadersHandler headersHandler) {
        this.formatResolver = formatResolver;
        this.result = result;
        this.serializations = serializations;
        Collections.reverse(this.serializations);
        this.headersHandler = headersHandler;
    }

    @Override
    public <T> Serializer from(T object) {
        if (HypermediaResource.class.isAssignableFrom(object.getClass())) {
            this.headersHandler.handle((HypermediaResource)HypermediaResource.class.cast(object));
        }
        String format = this.formatResolver.getAcceptFormat();
        for (Serialization serialization : this.serializations) {
            if (!serialization.accepts(format)) continue;
            return serialization.from(object);
        }
        this.result.forward();
        return new IgnoringSerializer();
    }
}

