/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.xstream;

import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.ioc.Component;
import br.com.caelum.vraptor.serialization.JSONSerialization;
import br.com.caelum.vraptor.serialization.NoRootSerialization;
import br.com.caelum.vraptor.serialization.ProxyInitializer;
import br.com.caelum.vraptor.serialization.Serializer;
import br.com.caelum.vraptor.serialization.SerializerBuilder;
import br.com.caelum.vraptor.serialization.xstream.VRaptorClassMapper;
import br.com.caelum.vraptor.serialization.xstream.XStreamSerializer;
import br.com.caelum.vraptor.view.ResultException;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class XStreamJSONSerialization
implements JSONSerialization {
    private final HttpServletResponse response;
    private final TypeNameExtractor extractor;
    private final ProxyInitializer initializer;
    private HierarchicalStreamDriver driver = new JsonHierarchicalStreamDriver();

    public XStreamJSONSerialization(HttpServletResponse response, TypeNameExtractor extractor, ProxyInitializer initializer) {
        this.response = response;
        this.extractor = extractor;
        this.initializer = initializer;
    }

    @Override
    public boolean accepts(String format) {
        return "json".equals(format);
    }

    @Override
    public <T> Serializer from(T object) {
        this.response.setContentType("application/json");
        return this.getSerializer().from(object);
    }

    protected SerializerBuilder getSerializer() {
        try {
            return new XStreamSerializer(this.getXStream(), this.response.getWriter(), this.extractor, this.initializer);
        }
        catch (IOException e) {
            throw new ResultException("Unable to serialize data", e);
        }
    }

    @Override
    public <T> Serializer from(T object, String alias) {
        this.response.setContentType("application/json");
        return this.getSerializer().from(object, alias);
    }

    protected XStream getXStream() {
        return new XStream(this.getHierarchicalStreamDriver()){
            {
                this.setMode(1001);
            }

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new VRaptorClassMapper((Mapper)next, XStreamJSONSerialization.this.extractor);
            }
        };
    }

    protected HierarchicalStreamDriver getHierarchicalStreamDriver() {
        return this.driver;
    }

    @Override
    public <T> NoRootSerialization withoutRoot() {
        this.driver = new JsonHierarchicalStreamDriver(){

            public HierarchicalStreamWriter createWriter(Writer writer) {
                return new JsonWriter(writer, 1);
            }
        };
        return this;
    }
}

