/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.xstream;

import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.serialization.ProxyInitializer;
import br.com.caelum.vraptor.serialization.Serializer;
import br.com.caelum.vraptor.serialization.SerializerBuilder;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.vidageek.mirror.dsl.Mirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XStreamSerializer
implements SerializerBuilder {
    private final XStream xstream;
    private final Writer writer;
    private Object root;
    private Class<?> rootClass;
    private final Multimap<Class<?>, String> excludes = LinkedListMultimap.create();
    private Set<Class<?>> elementTypes;
    private final TypeNameExtractor extractor;
    private final ProxyInitializer initializer;

    public XStreamSerializer(XStream xstream, Writer writer, TypeNameExtractor extractor, ProxyInitializer initializer) {
        this.xstream = xstream;
        this.writer = writer;
        this.extractor = extractor;
        this.initializer = initializer;
    }

    private boolean isPrimitive(Class<?> type) {
        return type.isPrimitive() || type.isEnum() || Number.class.isAssignableFrom(type) || type.equals(String.class) || Date.class.isAssignableFrom(type) || Calendar.class.isAssignableFrom(type) || Boolean.class.equals(type) || Character.class.equals(type);
    }

    @Override
    public Serializer exclude(String ... names) {
        for (String name : names) {
            Set<Class<?>> parentTypes = this.getParentTypesFor(name);
            for (Class<?> type : parentTypes) {
                this.xstream.omitField(type, this.getNameFor(name));
            }
        }
        return this;
    }

    private String getNameFor(String name) {
        String[] path = name.split("\\.");
        return path[path.length - 1];
    }

    private Set<Class<?>> getParentTypesFor(String name) {
        if (this.elementTypes == null) {
            Class<?> type = this.rootClass;
            return Collections.singleton(this.getParentType(name, type));
        }
        HashSet result = new HashSet();
        for (Class<?> type : this.elementTypes) {
            result.add(this.getParentType(name, type));
        }
        return result;
    }

    private Class<?> getParentType(String name, Class<?> type) {
        String[] path = name.split("\\.");
        for (int i = 0; i < path.length - 1; ++i) {
            type = this.getActualType(new Mirror().on(type).reflect().field(path[i]).getGenericType());
        }
        return type;
    }

    private void preConfigure(Object obj, String alias) {
        if (obj == null) {
            throw new NullPointerException("You can't serialize null objects");
        }
        this.xstream.processAnnotations(obj.getClass());
        this.rootClass = this.initializer.getActualClass(obj);
        if (alias == null && this.initializer.isProxy(obj.getClass())) {
            alias = this.extractor.nameFor(this.rootClass);
        }
        if (Collection.class.isInstance(obj)) {
            ArrayList<Object> list = new ArrayList<Object>((Collection)obj);
            this.elementTypes = this.findElementTypes(list);
            for (Class<?> type : this.elementTypes) {
                this.excludeNonPrimitiveFields(type);
            }
            this.root = list;
        } else {
            Class<?> type = this.rootClass;
            this.excludeNonPrimitiveFields(type);
            this.root = obj;
        }
        if (alias != null) {
            if (Collection.class.isInstance(obj)) {
                this.xstream.alias(alias, List.class);
            } else {
                this.xstream.alias(alias, obj.getClass());
            }
        }
    }

    @Override
    public <T> Serializer from(T object, String alias) {
        this.preConfigure(object, alias);
        return this;
    }

    @Override
    public <T> Serializer from(T object) {
        this.preConfigure(object, null);
        return this;
    }

    private Set<Class<?>> findElementTypes(List<Object> list) {
        HashSet set = new HashSet();
        for (Object element : list) {
            if (element == null || this.isPrimitive(element.getClass())) continue;
            set.add(this.initializer.getActualClass(element));
        }
        return set;
    }

    private void excludeNonPrimitiveFields(Class<?> type) {
        for (Field field : new Mirror().on(type).reflectAll().fields()) {
            if (this.isPrimitive(field.getType())) continue;
            this.excludes.put(type, (Object)field.getName());
        }
    }

    @Override
    public Serializer include(String ... fields) {
        for (String field : fields) {
            try {
                Set<Class<?>> parentTypes = this.getParentTypesFor(field);
                String fieldName = this.getNameFor(field);
                for (Class<?> parentType : parentTypes) {
                    Type genericType = new Mirror().on(parentType).reflect().field(fieldName).getGenericType();
                    Class<?> fieldType = this.getActualType(genericType);
                    if (!this.excludes.containsKey(fieldType)) {
                        this.excludeNonPrimitiveFields(fieldType);
                    }
                    this.excludes.remove(parentType, (Object)fieldName);
                }
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("Field path " + field + " doesn't exist");
            }
        }
        return this;
    }

    private Class<?> getActualType(Type genericType) {
        ParameterizedType type;
        if (genericType instanceof ParameterizedType && this.isCollection(type = (ParameterizedType)genericType)) {
            return (Class)type.getActualTypeArguments()[0];
        }
        return (Class)genericType;
    }

    private boolean isCollection(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            return Collection.class.isAssignableFrom((Class)ptype.getRawType()) || Map.class.isAssignableFrom((Class)ptype.getRawType());
        }
        return Collection.class.isAssignableFrom((Class)type);
    }

    @Override
    public void serialize() {
        for (Map.Entry exclude : this.excludes.entries()) {
            this.xstream.omitField((Class)exclude.getKey(), (String)exclude.getValue());
        }
        this.registerProxyInitializer();
        this.xstream.toXML(this.root, this.writer);
    }

    @Override
    public Serializer recursive() {
        this.excludes.clear();
        return this;
    }

    private void registerProxyInitializer() {
        this.xstream.registerConverter(new Converter(){

            public boolean canConvert(Class clazz) {
                return XStreamSerializer.this.initializer.isProxy(clazz);
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                throw new AssertionError();
            }

            public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
                Converter converter = XStreamSerializer.this.xstream.getConverterLookup().lookupConverterForType(XStreamSerializer.this.initializer.getActualClass(value));
                XStreamSerializer.this.initializer.initialize(value);
                converter.marshal(value, writer, context);
            }
        });
    }
}

