/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.util.hibernate;

import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.resource.ResourceMethod;
import org.hibernate.Session;
import org.hibernate.Transaction;

@Intercepts
public class HibernateTransactionInterceptor
implements Interceptor {
    private final Session session;

    public HibernateTransactionInterceptor(Session session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intercept(InterceptorStack stack, ResourceMethod method, Object instance) {
        Transaction transaction = null;
        try {
            transaction = this.session.beginTransaction();
            stack.next(method, instance);
            transaction.commit();
        }
        finally {
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
        }
    }

    public boolean accepts(ResourceMethod method) {
        return true;
    }
}

