/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.util.interceptors;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.resource.ResourceMethod;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EncodingInterceptor
implements Interceptor {
    private static final String UTF_8 = "UTF-8";
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public EncodingInterceptor(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public boolean accepts(ResourceMethod method) {
        return true;
    }

    public void intercept(InterceptorStack stack, ResourceMethod method, Object resourceInstance) throws InterceptionException {
        try {
            this.request.setCharacterEncoding(UTF_8);
            this.response.setCharacterEncoding(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new InterceptionException(e);
        }
        stack.next(method, resourceInstance);
    }
}

