/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.util.jpa;

import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.resource.ResourceMethod;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;

@Intercepts
public class JPATransactionInterceptor
implements Interceptor {
    private final EntityManager manager;

    public JPATransactionInterceptor(EntityManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intercept(InterceptorStack stack, ResourceMethod method, Object instance) {
        EntityTransaction transaction = null;
        try {
            transaction = this.manager.getTransaction();
            transaction.begin();
            stack.next(method, instance);
            transaction.commit();
        }
        finally {
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
        }
    }

    public boolean accepts(ResourceMethod method) {
        return true;
    }
}

