/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.util.migration;

import br.com.caelum.vraptor.VRaptorException;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.Component;
import br.com.caelum.vraptor.util.migration.ConnectionProvider;
import br.com.caelum.vraptor.util.migration.Migration;
import br.com.caelum.vraptor.util.migration.MigrationInfo;
import br.com.caelum.vraptor.util.migration.Migrations;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@ApplicationScoped
public class HibernateConnectionProvider
implements ConnectionProvider {
    private final SessionFactory factory;

    public HibernateConnectionProvider(SessionFactory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Migrations migrations) throws VRaptorException {
        Session session = this.factory.openSession();
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            for (Migration migration : migrations.getAll()) {
                this.execute((org.hibernate.Session)session, migration);
            }
            tx.commit();
        }
        finally {
            if (tx != null && !tx.wasCommitted()) {
                tx.rollback();
            }
            session.close();
        }
    }

    private void execute(org.hibernate.Session session, Migration<org.hibernate.Session> migration) {
        migration.execute(session);
        session.save((Object)new MigrationInfo(migration.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAppliedMigrations() {
        Session session = this.factory.openSession();
        try {
            List list = session.createQuery("select id from MigrationInfo").list();
            return list;
        }
        finally {
            session.close();
        }
    }
}

