/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.util.migration;

import br.com.caelum.vraptor.VRaptorException;
import br.com.caelum.vraptor.ioc.Component;
import br.com.caelum.vraptor.ioc.pico.Scanner;
import br.com.caelum.vraptor.util.migration.Migration;
import br.com.caelum.vraptor.util.migration.Migrations;
import br.com.caelum.vraptor.util.migration.MigrationsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationsLookupProvider
implements MigrationsProvider {
    private final Scanner scanner;

    public MigrationsLookupProvider(Scanner scanner) {
        this.scanner = scanner;
    }

    @Override
    public Migrations all() {
        Collection<Class<? extends Migration>> migrationTypes = this.scanner.getSubtypesOfWithAnnotation(Migration.class, Component.class);
        return new Migrations(this.instantiateAll(migrationTypes));
    }

    private List<Migration> instantiateAll(Collection<Class<? extends Migration>> migrationTypes) {
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        for (Class<? extends Migration> type : migrationTypes) {
            try {
                migrations.add(type.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new VRaptorException("Cannot instantiate migration: ", e);
            }
        }
        return migrations;
    }
}

