/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.util.migration;

import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.util.migration.ConnectionProvider;
import br.com.caelum.vraptor.util.migration.Migration;
import br.com.caelum.vraptor.util.migration.Migrations;
import br.com.caelum.vraptor.util.migration.MigrationsProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class Migrator {
    private static final Logger logger = LoggerFactory.getLogger(Migrator.class);
    private final ConnectionProvider provider;
    private final MigrationsProvider migrations;

    Migrator(ConnectionProvider provider, MigrationsProvider migrations) {
        this.provider = provider;
        this.migrations = migrations;
    }

    public Migrations getMigrationsToApply() {
        HashSet<String> applied = new HashSet<String>(this.provider.getAppliedMigrations());
        ArrayList<Migration> toApply = new ArrayList<Migration>(this.migrations.all().getAll());
        Iterator it = toApply.iterator();
        while (it.hasNext()) {
            Migration migration = (Migration)it.next();
            if (!applied.contains(migration.getId())) continue;
            it.remove();
        }
        return new Migrations(toApply);
    }

    @PostConstruct
    public void startup() {
        logger.info("Starting the Migrator");
        Migrations migrations = this.getMigrationsToApply();
        logger.debug("Full list of migrations found " + migrations);
        this.provider.apply(migrations);
    }
}

