/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.validator;

import br.com.caelum.vraptor.core.Localization;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.validator.BeanValidator;
import br.com.caelum.vraptor.validator.JSR303ValidatorFactory;
import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.validator.ValidationMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.metadata.ConstraintDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RequestScoped
public class JSR303Validator
implements BeanValidator {
    private static final Logger logger = LoggerFactory.getLogger(JSR303Validator.class);
    private static JSR303ValidatorFactory factory;
    private final Localization localization;

    public JSR303Validator(Localization localization) {
        this.localization = localization;
    }

    public static JSR303ValidatorFactory getFactory() {
        if (factory == null) {
            factory = new JSR303ValidatorFactory();
        }
        return factory;
    }

    @Override
    public List<Message> validate(Object bean) {
        if (bean == null) {
            logger.warn("skiping validation, input bean is null.");
            return Collections.emptyList();
        }
        Set violations = factory.getValidator().validate(bean, new Class[0]);
        logger.debug("there are {} violations at bean {}.", (Object)violations.size(), bean);
        ArrayList<Message> messages = new ArrayList<Message>();
        for (ConstraintViolation violation : violations) {
            Context ctx = new Context(violation.getConstraintDescriptor(), violation.getInvalidValue());
            String msg = factory.getInterpolator().interpolate(violation.getMessageTemplate(), (MessageInterpolator.Context)ctx, this.localization.getLocale());
            messages.add(new ValidationMessage(msg, violation.getPropertyPath().toString()));
            logger.debug("added message {} to validation of bean {}", (Object)msg, violation.getRootBean());
        }
        return messages;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Context
    implements MessageInterpolator.Context {
        private final ConstraintDescriptor<?> descriptor;
        private final Object validatedValue;

        public Context(ConstraintDescriptor<?> descriptor, Object validatedValue) {
            this.descriptor = descriptor;
            this.validatedValue = validatedValue;
        }

        public ConstraintDescriptor<?> getConstraintDescriptor() {
            return this.descriptor;
        }

        public Object getValidatedValue() {
            return this.validatedValue;
        }
    }
}

