/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.validator;

import br.com.caelum.vraptor.core.SafeResourceBundle;
import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.validator.ValidationMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.hamcrest.Matcher;
import org.hamcrest.ResourceBundleDescription;
import org.hamcrest.SelfDescribing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validations {
    private final List<Message> errors = new ArrayList<Message>();
    private final ResourceBundle bundle;

    public Validations(ResourceBundle bundle) {
        this.bundle = new SafeResourceBundle(bundle);
    }

    public Validations() {
        this(ResourceBundle.getBundle("messages"));
    }

    public <T> boolean that(T id, Matcher<? super T> matcher) {
        return this.that(id, matcher, "", null, new Object[0]);
    }

    public <T> boolean that(T id, Matcher<? super T> matcher, String category) {
        return this.that(id, matcher, category, null, new Object[0]);
    }

    public <T> boolean that(T actual, Matcher<? super T> matcher, String category, String reason, Object ... messageParameters) {
        if (!matcher.matches(actual)) {
            if (reason != null) {
                this.errors.add(new ValidationMessage(this.i18n(reason), category, messageParameters));
            } else {
                ResourceBundleDescription description = new ResourceBundleDescription(this.bundle);
                description.appendDescriptionOf((SelfDescribing)matcher);
                this.errors.add(new ValidationMessage(((Object)((Object)description)).toString(), category));
            }
            return false;
        }
        return true;
    }

    public boolean that(boolean assertion, String category, String reason, Object ... messageParameters) {
        if (!assertion) {
            this.errors.add(new ValidationMessage(this.i18n(reason), category, messageParameters));
        }
        return assertion;
    }

    protected String i18n(String key) {
        return this.bundle.getString(key);
    }

    public List<Message> getErrors() {
        return this.errors;
    }

    public Validations and(List<Message> errors) {
        this.errors.addAll(errors);
        return this;
    }

    public Validations and(Message error) {
        this.errors.add(error);
        return this;
    }
}

