/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.view;

import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.view.AcceptHeaderToFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ApplicationScoped
public class DefaultAcceptHeaderToFormat
implements AcceptHeaderToFormat {
    private static Cache cache = new Cache();
    private static final String DEFAULT_FORMAT = "html";
    private static final double DEFAULT_QUALIFIER_VALUE = 0.01;
    protected final Map<String, String> map = new ConcurrentHashMap<String, String>();

    public DefaultAcceptHeaderToFormat() {
        this.map.put("text/html", DEFAULT_FORMAT);
        this.map.put("application/json", "json");
        this.map.put("application/xml", "xml");
        this.map.put("xml", "xml");
    }

    public String getFormat(String acceptHeader) {
        String[] mimeTypes;
        if (acceptHeader == null) {
            throw new NullPointerException("accept header cant be null");
        }
        if (acceptHeader.contains(DEFAULT_FORMAT)) {
            return DEFAULT_FORMAT;
        }
        if (cache.containsKey(acceptHeader)) {
            return (String)cache.get(acceptHeader);
        }
        for (String mimeType : mimeTypes = this.getOrderedMimeTypes(acceptHeader)) {
            if (!this.map.containsKey(mimeType)) continue;
            String format = this.map.get(mimeType);
            cache.put(acceptHeader, format);
            return format;
        }
        return mimeTypes[0];
    }

    String[] getOrderedMimeTypes(String acceptHeader) {
        String[] types = acceptHeader.split(",");
        if (types.length == 0) {
            if (types[0].contains(";")) {
                return new String[]{types[0].substring(0, types[0].indexOf(59))};
            }
            return new String[]{types[0]};
        }
        ArrayList<MimeType> mimes = new ArrayList<MimeType>();
        for (String string : types) {
            if (string.contains("*/*")) {
                mimes.add(new MimeType("text/html", 0.01));
                continue;
            }
            if (string.contains(";")) {
                String type = string.substring(0, string.indexOf(59));
                double qualifier = 0.01;
                if (string.contains("q=")) {
                    Matcher matcher = Pattern.compile("\\s*q=(.+)\\s*").matcher(string);
                    matcher.find();
                    String value = matcher.group(1);
                    qualifier = Double.parseDouble(value);
                }
                mimes.add(new MimeType(type, qualifier));
                continue;
            }
            mimes.add(new MimeType(string, 1.0));
        }
        Collections.sort(mimes);
        String[] orderedTypes = new String[mimes.size()];
        for (int i = 0; i < mimes.size(); ++i) {
            orderedTypes[i] = ((MimeType)mimes.get(i)).getType().trim();
        }
        return orderedTypes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MimeType
    implements Comparable<MimeType> {
        String type;
        double qualifier;

        public MimeType(String type, double qualifier) {
            this.type = type;
            this.qualifier = qualifier;
        }

        @Override
        public int compareTo(MimeType mime) {
            return Double.compare(mime.qualifier, this.qualifier);
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Cache
    extends LinkedHashMap<String, String> {
        private Cache() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 100;
        }
    }
}

