/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.view;

import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.view.AcceptHeaderToFormat;
import br.com.caelum.vraptor.view.PathResolver;
import javax.servlet.http.HttpServletRequest;

@RequestScoped
public class DefaultPathResolver
implements PathResolver {
    private final HttpServletRequest request;
    private final AcceptHeaderToFormat acceptHeaderToFormat;

    public DefaultPathResolver(HttpServletRequest request, AcceptHeaderToFormat acceptHeaderToFormat) {
        this.request = request;
        this.acceptHeaderToFormat = acceptHeaderToFormat;
    }

    public String pathFor(ResourceMethod method) {
        String formatParam;
        String acceptedHeader = this.request.getHeader("Accept");
        String format = "html";
        if (acceptedHeader != null) {
            format = this.acceptHeaderToFormat.getFormat(acceptedHeader);
        }
        if ((formatParam = this.request.getParameter("_format")) != null) {
            format = formatParam;
        }
        String suffix = "";
        if (format != null && !format.equals("html")) {
            suffix = "." + format;
        }
        String name = method.getResource().getType().getSimpleName();
        String folderName = this.extractControllerFromName(name);
        return this.getPrefix() + folderName + "/" + method.getMethod().getName() + suffix + "." + this.getExtension();
    }

    protected String getPrefix() {
        return "/WEB-INF/jsp/";
    }

    protected String getExtension() {
        return "jsp";
    }

    protected String extractControllerFromName(String baseName) {
        if ((baseName = this.lowerFirstCharacter(baseName)).endsWith("Controller")) {
            return baseName.substring(0, baseName.lastIndexOf("Controller"));
        }
        return baseName;
    }

    private String lowerFirstCharacter(String baseName) {
        return baseName.toLowerCase().substring(0, 1) + baseName.substring(1, baseName.length());
    }
}

