/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.view;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.core.Localization;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.ParametersProvider;
import br.com.caelum.vraptor.http.route.MethodNotAllowedException;
import br.com.caelum.vraptor.http.route.ResourceNotFoundException;
import br.com.caelum.vraptor.http.route.Router;
import br.com.caelum.vraptor.resource.HttpMethod;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.view.RefererResult;
import br.com.caelum.vraptor.view.Results;
import java.util.ArrayList;
import net.vidageek.mirror.dsl.Mirror;

public class DefaultRefererResult
implements RefererResult {
    private final MutableRequest request;
    private final Result result;
    private final Router router;
    private final ParametersProvider provider;
    private final Localization localization;

    public DefaultRefererResult(Result result, MutableRequest request, Router router, ParametersProvider provider, Localization localization) {
        this.result = result;
        this.request = request;
        this.router = router;
        this.provider = provider;
        this.localization = localization;
    }

    public void forward() throws IllegalStateException {
        String referer = this.getReferer();
        try {
            ResourceMethod method = this.router.parse(referer, HttpMethod.GET, this.request);
            this.executeMethod(method, this.result.use(Results.logic()).forwardTo(method.getResource().getType()));
        }
        catch (ResourceNotFoundException e) {
            this.result.use(Results.page()).forward(referer);
        }
        catch (MethodNotAllowedException e) {
            this.result.use(Results.page()).forward(referer);
        }
    }

    private void executeMethod(ResourceMethod method, Object instance) {
        new Mirror().on(instance).invoke().method(method.getMethod()).withArgs(this.provider.getParametersFor(method, new ArrayList<Message>(), this.localization.getBundle()));
    }

    public void redirect() throws IllegalStateException {
        String referer = this.getReferer();
        try {
            ResourceMethod method = this.router.parse(referer, HttpMethod.GET, this.request);
            this.executeMethod(method, this.result.use(Results.logic()).redirectTo(method.getResource().getType()));
        }
        catch (ResourceNotFoundException e) {
            this.result.use(Results.page()).redirect(referer);
        }
        catch (MethodNotAllowedException e) {
            this.result.use(Results.page()).redirect(referer);
        }
    }

    private String getReferer() {
        String referer = this.request.getHeader("Referer");
        if (referer == null) {
            throw new IllegalStateException("The Referer header was not specified");
        }
        String path = this.request.getContextPath();
        return referer.substring(referer.indexOf(path) + path.length());
    }
}

