/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.view;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.config.Configuration;
import br.com.caelum.vraptor.http.route.Router;
import br.com.caelum.vraptor.ioc.Component;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.SuperMethod;
import br.com.caelum.vraptor.resource.HttpMethod;
import br.com.caelum.vraptor.view.ResultException;
import br.com.caelum.vraptor.view.Results;
import br.com.caelum.vraptor.view.Status;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.EnumSet;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class DefaultStatus
implements Status {
    private final HttpServletResponse response;
    private final Result result;
    private final Configuration config;
    private final Router router;
    private final Proxifier proxifier;

    public DefaultStatus(HttpServletResponse response, Result result, Configuration config, Proxifier proxifier, Router router) {
        this.response = response;
        this.result = result;
        this.config = config;
        this.proxifier = proxifier;
        this.router = router;
    }

    @Override
    public void notFound() {
        this.response.setStatus(404);
        this.result.use(Results.nothing());
    }

    @Override
    public void header(String key, String value) {
        this.response.addHeader(key, value);
    }

    @Override
    public void created() {
        this.response.setStatus(201);
        this.result.use(Results.nothing());
    }

    @Override
    public void created(String location) {
        this.header("Location", this.fixLocation(location));
        this.created();
    }

    @Override
    public void ok() {
        this.response.setStatus(200);
        this.result.use(Results.nothing());
    }

    @Override
    public void conflict() {
        this.response.setStatus(409);
        this.result.use(Results.nothing());
    }

    @Override
    public void methodNotAllowed(EnumSet<HttpMethod> allowedMethods) {
        this.header("Allow", allowedMethods.toString().replaceAll("\\[|\\]", ""));
        this.response.setStatus(405);
        this.result.use(Results.nothing());
    }

    @Override
    public void movedPermanentlyTo(String location) {
        this.response.setStatus(301);
        this.header("Location", this.fixLocation(location));
        this.response.addIntHeader("Content-length", 0);
        this.response.addDateHeader("Date", System.currentTimeMillis());
    }

    private String fixLocation(String location) {
        if (location.startsWith("/")) {
            return this.config.getApplicationPath() + location;
        }
        return location;
    }

    @Override
    public <T> T movedPermanentlyTo(final Class<T> controller) {
        return this.proxifier.proxify(controller, new MethodInvocation<T>(){

            @Override
            public Object intercept(T proxy, Method method, Object[] args, SuperMethod superMethod) {
                String uri = DefaultStatus.this.router.urlFor(controller, method, args);
                DefaultStatus.this.movedPermanentlyTo(uri);
                return null;
            }
        });
    }

    @Override
    public void unsupportedMediaType(String message) {
        try {
            this.response.sendError(415, message);
            this.result.use(Results.nothing());
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    @Override
    public void badRequest(String message) {
        try {
            this.response.sendError(400, message);
            this.result.use(Results.nothing());
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    @Override
    public void forbidden(String message) {
        try {
            this.response.sendError(403, message);
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    @Override
    public void noContent() {
        this.response.setStatus(204);
    }
}

