/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.vraptor2;

import br.com.caelum.vraptor.http.route.PathAnnotationRoutesParser;
import br.com.caelum.vraptor.http.route.Route;
import br.com.caelum.vraptor.http.route.RouteBuilder;
import br.com.caelum.vraptor.http.route.RoutesParser;
import br.com.caelum.vraptor.http.route.TypeFinder;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.resource.HttpMethod;
import br.com.caelum.vraptor.resource.ResourceClass;
import br.com.caelum.vraptor.vraptor2.Info;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vraptor.annotations.In;
import org.vraptor.annotations.Logic;
import org.vraptor.annotations.Out;
import org.vraptor.annotations.Parameter;
import org.vraptor.plugin.hibernate.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class ComponentRoutesParser
implements RoutesParser {
    private final Proxifier proxifier;
    private final RoutesParser delegate;
    private final Logger logger = LoggerFactory.getLogger(ComponentRoutesParser.class);
    private final TypeFinder finder;

    public ComponentRoutesParser(Proxifier proxifier, TypeFinder finder) {
        this.proxifier = proxifier;
        this.finder = finder;
        this.delegate = new PathAnnotationRoutesParser(proxifier, finder);
    }

    @Override
    public List<Route> rulesFor(ResourceClass resource) {
        ArrayList<Route> routes = new ArrayList<Route>();
        Class<?> type = resource.getType();
        if (!Info.isOldComponent(resource)) {
            return this.delegate.rulesFor(resource);
        }
        this.logger.warn("VRaptor2 component found, you should migrate it to VRaptor3: " + type.getName());
        this.registerRulesFor(type, type, routes);
        this.parse(type, type);
        return routes;
    }

    private void parse(Class<?> type, Class<?> originalType) {
        if (type.equals(Object.class)) {
            return;
        }
        for (Class clazz : new Class[]{Out.class, In.class, Parameter.class}) {
            for (Field field : type.getDeclaredFields()) {
                if (!field.isAnnotationPresent(clazz)) continue;
                this.logger.error("Field " + field.getName() + " from " + originalType.getName() + " is annotated with " + clazz.getName() + " but is not supported by VRaptor3! Read the migration guide.");
            }
        }
        for (GenericDeclaration genericDeclaration : type.getDeclaredMethods()) {
            Validate validate;
            for (AnnotatedElement annotatedElement : new Class[]{Out.class, In.class}) {
                if (!((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent((Class<? extends Annotation>)annotatedElement)) continue;
                this.logger.error("Method " + ((Method)genericDeclaration).getName() + " from " + originalType.getName() + " is annotated with " + ((Class)annotatedElement).getName() + " but is not supported by VRaptor3! Read the migration guide.");
            }
            if (((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent(Logic.class)) {
                this.logger.warn("Method " + ((Method)genericDeclaration).getName() + " from " + originalType.getName() + " is annotated with @Logic. Although its supported, we suggest you to migrate to @Path.");
            }
            if (!((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent(Validate.class) || (validate = ((Method)genericDeclaration).getAnnotation(Validate.class)).fields().length == 0) continue;
            this.logger.error("Method " + ((Method)genericDeclaration).getName() + " from " + originalType.getName() + " is annotated with @Validate with fields. This is not supported.");
        }
        this.parse(type.getSuperclass(), type);
    }

    private void registerRulesFor(Class<?> actualType, Class<?> baseType, List<Route> routes) {
        if (actualType.equals(Object.class)) {
            return;
        }
        for (Method javaMethod : actualType.getDeclaredMethods()) {
            if (!this.isEligible(javaMethod) || this.isGetter(javaMethod)) continue;
            String uri = this.getUriFor(javaMethod, baseType);
            RouteBuilder builder = new RouteBuilder(this.proxifier, this.finder, uri);
            for (HttpMethod m : HttpMethod.values()) {
                if (!javaMethod.isAnnotationPresent(m.getAnnotation())) continue;
                builder.with(m);
            }
            builder.is(baseType, javaMethod);
            routes.add(builder.build());
        }
        this.registerRulesFor(actualType.getSuperclass(), baseType, routes);
    }

    private boolean isGetter(Method javaMethod) {
        return javaMethod.getName().startsWith("get") || javaMethod.getName().startsWith("is");
    }

    private String getUriFor(Method javaMethod, Class<?> type) {
        String componentName = Info.getComponentName(type);
        String logicName = Info.getLogicName(javaMethod);
        return "/" + componentName + "." + logicName + ".logic";
    }

    private boolean isEligible(Method javaMethod) {
        return Modifier.isPublic(javaMethod.getModifiers()) && !Modifier.isStatic(javaMethod.getModifiers());
    }
}

