/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.vraptor2;

import br.com.caelum.vraptor.core.RequestInfo;
import br.com.caelum.vraptor.vraptor2.ExpressionEvaluationException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class ExpressionEvaluator {
    private final Map<String, Method> cache = new HashMap<String, Method>();

    ExpressionEvaluator() {
    }

    public String parseExpression(String expression, RequestInfo request) throws ExpressionEvaluationException {
        boolean in = false;
        int start = 0;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c == '$') {
                if (in || expression.length() - 1 == i || expression.charAt(i + 1) != '{') {
                    throw new ExpressionEvaluationException("Invalid expression " + expression);
                }
                in = true;
                start = ++i + 1;
                continue;
            }
            if (c == '}' && in) {
                in = false;
                result.append(this.evaluate(expression.substring(start, i), request));
                continue;
            }
            if (in) continue;
            result.append(c);
        }
        return result.toString();
    }

    private String evaluate(String expression, RequestInfo request) throws ExpressionEvaluationException {
        if ("".equals(expression)) {
            return "";
        }
        String[] parts = expression.split("\\.");
        Object current = this.findAttribute(request, parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            if (current == null) {
                throw new ExpressionEvaluationException("Invalid redirection using: " + expression);
            }
            current = this.invokeGetter(current, parts[i]);
        }
        return current == null ? "" : current.toString();
    }

    private Object findAttribute(RequestInfo request, String key) {
        Object value = request.getRequest().getAttribute(key);
        if (value != null) {
            return value;
        }
        value = request.getRequest().getSession().getAttribute(key);
        if (value != null) {
            return value;
        }
        return request.getServletContext().getAttribute(key);
    }

    private Object invokeGetter(Object obj, String property) throws ExpressionEvaluationException {
        property = "get" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
        String key = obj.getClass().getName() + "." + property;
        try {
            if (!this.cache.containsKey(key)) {
                this.cache.put(key, obj.getClass().getMethod(property, new Class[0]));
            }
            return this.cache.get(key).invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException("Invalid expression " + property, e);
        }
    }
}

