/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.vraptor2;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.core.Localization;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.vraptor2.FallbackResourceBundle;
import br.com.caelum.vraptor.vraptor2.Info;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.vraptor.i18n.FixedMessage;
import org.vraptor.i18n.Message;
import org.vraptor.i18n.ValidationMessage;
import org.vraptor.plugin.hibernate.HibernateLogicMethod;
import org.vraptor.plugin.hibernate.Validate;
import org.vraptor.plugin.hibernate.ValidatorLocator;
import org.vraptor.reflection.GettingException;
import org.vraptor.validator.BasicValidationErrors;
import org.vraptor.validator.ValidationErrors;

public class HibernateValidatorPluginInterceptor
implements Interceptor {
    private final ValidationErrors errors;
    private final ParameterNameProvider provider;
    private final HttpServletRequest request;
    private static final ValidatorLocator locator = new ValidatorLocator();
    private final MethodInfo parameters;
    private final Localization localization;

    public HibernateValidatorPluginInterceptor(ValidationErrors errors, ParameterNameProvider provider, HttpServletRequest request, MethodInfo parameters, Localization localization) {
        this.errors = errors;
        this.provider = provider;
        this.request = request;
        this.parameters = parameters;
        this.localization = localization;
    }

    public boolean accepts(ResourceMethod method) {
        return method.getMethod().isAnnotationPresent(Validate.class);
    }

    public void intercept(InterceptorStack stack, ResourceMethod method, Object resourceInstance) throws InterceptionException {
        Validate validate = method.getMethod().getAnnotation(Validate.class);
        if (validate != null) {
            ResourceBundle validatorBundle = ResourceBundle.getBundle("org.hibernate.validator.resources.DefaultValidatorMessages", this.request.getLocale());
            FallbackResourceBundle bundle = new FallbackResourceBundle(this.localization.getBundle(), validatorBundle);
            String[] names = this.provider.parameterNamesFor(method.getMethod());
            for (String path : validate.params()) {
                try {
                    Object[] paramValues = this.parameters.getParameters();
                    Object object = this.paramFor(names, path, paramValues);
                    BasicValidationErrors newErrors = new BasicValidationErrors();
                    HibernateLogicMethod.validateParam((ValidatorLocator)locator, (HttpServletRequest)this.request, (ResourceBundle)bundle, (ValidationErrors)newErrors, (Object)object, (String)path);
                    for (ValidationMessage msg : newErrors) {
                        String content;
                        FixedMessage m;
                        if (msg instanceof FixedMessage) {
                            m = (FixedMessage)msg;
                            content = bundle.getString(m.getKey());
                            this.errors.add((ValidationMessage)new FixedMessage(msg.getPath(), content, msg.getCategory()));
                            continue;
                        }
                        if (msg instanceof Message) {
                            m = (Message)msg;
                            content = bundle.getString(m.getKey());
                            content = MessageFormat.format(content, new Object[]{m.getParameters()});
                            this.errors.add((ValidationMessage)new FixedMessage(msg.getPath(), content, msg.getCategory()));
                            continue;
                        }
                        throw new IllegalArgumentException("Unsupported validation message type: " + msg.getClass().getName());
                    }
                }
                catch (GettingException e) {
                    throw new InterceptionException("Unable to validate objects due to an exception during validation.", e);
                }
            }
        }
        stack.next(method, resourceInstance);
    }

    private Object paramFor(String[] names, String path, Object[] values) throws InterceptionException {
        String param = path;
        if (param.indexOf(".") != -1) {
            param = param.substring(param.indexOf("."));
        }
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(param) && !names[i].equals(Info.capitalize(param))) continue;
            return values[i];
        }
        throw new InterceptionException("Unable to find param for hibernate validator: '" + path + "'");
    }
}

