/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.vraptor2;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.Validator;
import br.com.caelum.vraptor.View;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.util.test.MockResult;
import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.validator.ValidationException;
import br.com.caelum.vraptor.validator.Validations;
import br.com.caelum.vraptor.view.Results;
import br.com.caelum.vraptor.view.ValidationViewsFactory;
import br.com.caelum.vraptor.vraptor2.Info;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.vraptor.i18n.FixedMessage;
import org.vraptor.i18n.ValidationMessage;
import org.vraptor.validator.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RequestScoped
public class MessageCreatorValidator
implements Validator {
    private final Result result;
    private final ValidationErrors errors;
    private final ResourceMethod resource;
    private final MethodInfo info;
    private boolean containsErrors;
    private final ValidationViewsFactory viewsFactory;

    public MessageCreatorValidator(Result result, ValidationErrors errors, MethodInfo info, ValidationViewsFactory viewsFactory) {
        this.result = result;
        this.errors = errors;
        this.viewsFactory = viewsFactory;
        this.resource = info.getResourceMethod();
        this.info = info;
    }

    @Override
    public void checking(Validations validations) {
        List<Message> messages = validations.getErrors();
        for (Message s : messages) {
            this.add(s);
        }
    }

    @Override
    public void validate(Object object) {
        throw new UnsupportedOperationException("this feature is not supported by vraptor2");
    }

    @Override
    public <T extends View> T onErrorUse(Class<T> view) {
        if (!this.hasErrors()) {
            return new MockResult().use(view);
        }
        this.result.include("errors", this.errors);
        if (Info.isOldComponent(this.resource.getResource())) {
            this.info.setResult("invalid");
            this.result.use(Results.page()).forward();
            throw new ValidationException(new ArrayList<Message>());
        }
        return this.viewsFactory.instanceFor(view, new ArrayList<Message>());
    }

    @Override
    public void add(Message message) {
        this.containsErrors = true;
        this.errors.add((ValidationMessage)new FixedMessage(message.getCategory(), message.getMessage(), message.getCategory()));
    }

    @Override
    public void addAll(Collection<? extends Message> messages) {
        for (Message message : messages) {
            this.add(message);
        }
    }

    @Override
    public boolean hasErrors() {
        return this.containsErrors;
    }
}

