/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.vraptor2;

import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.resource.ResourceClass;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.view.AcceptHeaderToFormat;
import br.com.caelum.vraptor.view.DefaultPathResolver;
import br.com.caelum.vraptor.view.PathResolver;
import br.com.caelum.vraptor.vraptor2.Config;
import br.com.caelum.vraptor.vraptor2.Info;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class VRaptor2PathResolver
implements PathResolver {
    private static final Logger logger = LoggerFactory.getLogger(VRaptor2PathResolver.class);
    private final PathResolver vraptor3;
    private final String pattern;
    private final MethodInfo info;

    public VRaptor2PathResolver(Config config, HttpServletRequest request, MethodInfo info) {
        this.info = info;
        this.pattern = config.getViewPattern();
        this.vraptor3 = new DefaultPathResolver(request, new AcceptHeaderToFormat(){

            public String getFormat(String mimeType) {
                return "html";
            }
        });
    }

    public String pathFor(ResourceMethod method) {
        ResourceClass resource = method.getResource();
        if (Info.isOldComponent(resource)) {
            String component = Info.getComponentName(resource.getType());
            String logicName = Info.getLogicName(method.getMethod());
            logger.debug("path for {} - {}", (Object)component, (Object)logicName);
            return this.pattern.replaceAll("\\$component", component).replaceAll("\\$logic", logicName).replaceAll("\\$result", this.info.getResult().toString());
        }
        return this.vraptor3.pathFor(method);
    }
}

