/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.vraptor2;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.core.Localization;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.http.ParametersProvider;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.view.Results;
import br.com.caelum.vraptor.vraptor2.Info;
import br.com.caelum.vraptor.vraptor2.outject.OutjectionInterceptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vraptor.i18n.FixedMessage;
import org.vraptor.i18n.ValidationMessage;
import org.vraptor.validator.BasicValidationErrors;
import org.vraptor.validator.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorInterceptor
implements Interceptor {
    private final ParametersProvider provider;
    private final Result result;
    private static final Logger logger = LoggerFactory.getLogger(ValidatorInterceptor.class);
    private final ValidationErrors errors;
    private final OutjectionInterceptor outjection;
    private final Localization localization;
    private final MethodInfo info;

    public ValidatorInterceptor(ParametersProvider provider, Result result, ValidationErrors errors, OutjectionInterceptor outjection, Localization localization, MethodInfo info) {
        this.provider = provider;
        this.result = result;
        this.errors = errors;
        this.outjection = outjection;
        this.localization = localization;
        this.info = info;
    }

    @Override
    public boolean accepts(ResourceMethod method) {
        return true;
    }

    @Override
    public void intercept(InterceptorStack stack, ResourceMethod method, Object resourceInstance) throws InterceptionException {
        if (Info.isOldComponent(method.getResource())) {
            Class<?> type = method.getResource().getType();
            Method validationMethod = this.getValidationFor(method.getMethod(), type);
            if (validationMethod != null) {
                ArrayList<Message> convertionErrors = new ArrayList<Message>();
                ResourceBundle bundle = this.localization.getBundle();
                Object[] parameters = this.provider.getParametersFor(method, convertionErrors, bundle);
                Object[] validationParameters = new Object[parameters.length + 1];
                BasicValidationErrors newErrors = new BasicValidationErrors();
                validationParameters[0] = newErrors;
                System.arraycopy(parameters, 0, validationParameters, 1, parameters.length);
                try {
                    validationMethod.invoke(resourceInstance, validationParameters);
                }
                catch (IllegalArgumentException e) {
                    throw new InterceptionException("Unable to validate.", e);
                }
                catch (IllegalAccessException e) {
                    throw new InterceptionException("Unable to validate.", e);
                }
                catch (InvocationTargetException e) {
                    throw new InterceptionException("Unable to validate.", e.getCause());
                }
                for (Message msg : convertionErrors) {
                    this.errors.add((ValidationMessage)new FixedMessage(msg.getCategory(), msg.getMessage(), msg.getCategory()));
                }
                for (Message msg : newErrors) {
                    if (msg instanceof FixedMessage) {
                        this.errors.add((ValidationMessage)msg);
                        continue;
                    }
                    if (msg instanceof org.vraptor.i18n.Message) {
                        org.vraptor.i18n.Message m = (org.vraptor.i18n.Message)msg;
                        String content = this.localization.getMessage(m.getKey(), m.getParameters());
                        this.errors.add((ValidationMessage)new FixedMessage(msg.getPath(), content, msg.getCategory()));
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported validation message type: " + msg.getClass().getName());
                }
            }
            if (this.errors.size() != 0) {
                this.outjection.outject(resourceInstance, type);
                this.result.include("errors", this.errors);
                this.info.setResult("invalid");
                this.result.use(Results.page()).forward();
                return;
            }
        }
        stack.next(method, resourceInstance);
    }

    private <T> Method getValidationFor(Method method, Class<T> type) {
        String validationMethodName = "validate" + this.capitalize(method.getName());
        for (Method m : type.getDeclaredMethods()) {
            if (!m.getName().equals(validationMethodName)) continue;
            if (m.getParameterTypes().length != method.getParameterTypes().length + 1) {
                logger.error("Validate method for " + method + " has a different number of args+1!");
            }
            return m;
        }
        return null;
    }

    private String capitalize(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }
}

