/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.vraptor2;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.view.PageResult;
import br.com.caelum.vraptor.vraptor2.ComponentInfoProvider;
import br.com.caelum.vraptor.vraptor2.Info;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(ViewInterceptor.class);
    private final PageResult result;
    private final ComponentInfoProvider info;

    public ViewInterceptor(PageResult result, ComponentInfoProvider info) {
        this.result = result;
        this.info = info;
    }

    public boolean accepts(ResourceMethod method) {
        return true;
    }

    public void intercept(InterceptorStack stack, ResourceMethod method, Object resourceInstance) throws InterceptionException {
        boolean vraptor2 = Info.isOldComponent(method.getResource());
        if (vraptor2) {
            if (this.info.shouldShowView(method)) {
                logger.debug("VRaptor 2 component forward");
                this.result.forward();
            } else {
                logger.debug("Not forwarding (viewless component)");
            }
        } else {
            stack.next(method, resourceInstance);
        }
    }
}

