/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.vraptor2;

import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.core.RequestInfo;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.ProxyInvocationException;
import br.com.caelum.vraptor.proxy.SuperMethod;
import br.com.caelum.vraptor.resource.DefaultResourceMethod;
import br.com.caelum.vraptor.resource.ResourceClass;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.view.DefaultPageResult;
import br.com.caelum.vraptor.view.PageResult;
import br.com.caelum.vraptor.view.PathResolver;
import br.com.caelum.vraptor.view.ResultException;
import br.com.caelum.vraptor.vraptor2.Config;
import br.com.caelum.vraptor.vraptor2.ExpressionEvaluationException;
import br.com.caelum.vraptor.vraptor2.ExpressionEvaluator;
import br.com.caelum.vraptor.vraptor2.Info;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewsPropertiesPageResult
implements PageResult {
    private static final Logger logger = LoggerFactory.getLogger(ViewsPropertiesPageResult.class);
    private final Config config;
    private final HttpServletRequest request;
    private final PathResolver resolver;
    private final ResourceMethod method;
    private final HttpServletResponse response;
    private final ExpressionEvaluator evaluator = new ExpressionEvaluator();
    private final RequestInfo webRequest;
    private final MethodInfo info;
    private final Proxifier proxifier;
    private final DefaultPageResult delegate;

    public ViewsPropertiesPageResult(Config config, PathResolver resolver, MethodInfo requestInfo, RequestInfo webRequest, MethodInfo info, Proxifier proxifier, DefaultPageResult delegate) {
        this.config = config;
        this.webRequest = webRequest;
        this.info = info;
        this.proxifier = proxifier;
        this.request = webRequest.getRequest();
        this.resolver = resolver;
        this.method = requestInfo.getResourceMethod();
        this.response = webRequest.getResponse();
        this.delegate = delegate;
    }

    @Override
    public void forward() {
        try {
            this.forward(this.method);
        }
        catch (ServletException e) {
            throw new ResultException(e);
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    private void forward(ResourceMethod method) throws ServletException, IOException {
        if (Info.isOldComponent(method.getResource())) {
            this.vraptor2Forward(method);
        } else {
            this.delegate.forward();
        }
    }

    private void vraptor2Forward(ResourceMethod method) throws ServletException, IOException {
        logger.debug("Forwading using VRaptor2 URLs");
        String result = this.info.getResult().toString();
        ResourceClass resource = method.getResource();
        String key = Info.getComponentName(resource.getType()) + "." + Info.getLogicName(method.getMethod()) + "." + result;
        String path = this.config.getForwardFor(key);
        if (path == null) {
            String forwardPath = this.resolver.pathFor(method);
            logger.debug("Forwading to {}", (Object)forwardPath);
            this.request.getRequestDispatcher(forwardPath).forward((ServletRequest)this.request, (ServletResponse)this.response);
        } else {
            try {
                result = this.evaluator.parseExpression(path, this.webRequest);
            }
            catch (ExpressionEvaluationException e) {
                throw new ServletException("Unable to redirect while evaluating expression '" + path + "'.", (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("overriden view found for " + key + " : " + path + " expressed as " + result);
            }
            if (result.startsWith("redirect:")) {
                this.response.sendRedirect(result.substring(9));
            } else {
                this.request.getRequestDispatcher(result).forward((ServletRequest)this.request, (ServletResponse)this.response);
            }
        }
    }

    @Override
    public <T> T of(final Class<T> controllerType) {
        return this.proxifier.proxify(controllerType, new MethodInvocation<T>(){

            @Override
            public Object intercept(T proxy, Method method, Object[] args, SuperMethod superMethod) {
                try {
                    ResourceMethod resourceMethod = DefaultResourceMethod.instanceFor(controllerType, method);
                    ViewsPropertiesPageResult.this.forward(resourceMethod);
                    return null;
                }
                catch (Exception e) {
                    throw new ProxyInvocationException(e);
                }
            }
        });
    }

    @Override
    public void include() {
        this.delegate.include();
    }

    @Override
    public void redirect(String url) {
        this.delegate.redirect(url);
    }

    @Override
    public void forward(String url) {
        this.delegate.forward(url);
    }
}

