/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.vraptor2.outject;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.vraptor2.BeanHelper;
import br.com.caelum.vraptor.vraptor2.ComponentInfoProvider;
import br.com.caelum.vraptor.vraptor2.outject.Outjecter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutjectionInterceptor
implements Interceptor {
    private static final String GET = "get";
    private static final String IS = "is";
    private static final Logger logger = LoggerFactory.getLogger(OutjectionInterceptor.class);
    private static final BeanHelper helper = new BeanHelper();
    private final Outjecter outjecter;

    public OutjectionInterceptor(ComponentInfoProvider provider) {
        this.outjecter = provider.getOutjecter();
    }

    @Override
    public boolean accepts(ResourceMethod method) {
        return true;
    }

    @Override
    public void intercept(InterceptorStack stack, ResourceMethod method, Object resourceInstance) throws InterceptionException {
        Class<?> type = method.getResource().getType();
        this.outject(resourceInstance, type);
        stack.next(method, resourceInstance);
    }

    public void outject(Object resourceInstance, Class<?> type) throws InterceptionException {
        Method[] methods;
        for (Method outject : methods = type.getDeclaredMethods()) {
            if (Modifier.isPublic(outject.getModifiers()) && outject.getName().length() < 3 || !outject.getName().startsWith(IS) && !outject.getName().startsWith(GET)) continue;
            if (outject.getParameterTypes().length != 0) {
                logger.error("A get method was found at " + type + " but was not used because it receives parameters. Fix it.");
                continue;
            }
            if (outject.getReturnType().equals(Void.TYPE)) {
                logger.error("A get method was found at " + type + " but was not used because it returns void. Fix it.");
                continue;
            }
            try {
                Object result = outject.invoke(resourceInstance, new Object[0]);
                String name = helper.nameForGetter(outject);
                logger.debug("Outjecting {} as {}", (Object)name, result);
                this.outjecter.include(name, result);
            }
            catch (IllegalArgumentException e) {
                throw new InterceptionException("Unable to outject value for " + outject.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new InterceptionException("Unable to outject value for " + outject.getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new InterceptionException("Unable to outject value for " + outject.getName(), e.getCause());
            }
        }
    }
}

