/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest;

import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.hamcrest.BaseDescription;
import org.hamcrest.Description;

public class ResourceBundleDescription
extends BaseDescription {
    private final Appendable out;
    private final ResourceBundle bundle;

    public ResourceBundleDescription(ResourceBundle bundle) {
        this(bundle, new StringBuilder());
    }

    public ResourceBundleDescription(ResourceBundle bundle, Appendable out) {
        this.out = out;
        this.bundle = bundle;
    }

    protected void append(char c) {
        try {
            this.out.append(c);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write description", e);
        }
    }

    protected void append(String str) {
        this.directAppend(str);
    }

    public Description appendText(String text) {
        String parsed;
        int len = text.length();
        int st = 0;
        char[] val = text.toCharArray();
        while (st < len && val[st] <= ' ') {
            this.append(val[st++]);
        }
        while (st < len && val[len - 1] <= ' ') {
            --len;
        }
        String string = parsed = st > 0 || len < text.length() ? text.substring(st, len) : text;
        if (parsed.length() != 0) {
            String keyValue = parsed.replace(' ', '_');
            try {
                String value = this.bundle.getString(keyValue);
                super.appendText(value);
            }
            catch (MissingResourceException ex) {
                super.appendText("???" + keyValue + "???");
            }
        }
        while (len != text.length()) {
            this.append(val[len++]);
        }
        return this;
    }

    protected void directAppend(String str) {
        try {
            this.out.append(str);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write description", e);
        }
    }

    public String toString() {
        return this.out.toString();
    }
}

