/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.cache;

import br.com.caelum.vraptor.cache.CacheException;
import br.com.caelum.vraptor.cache.CacheStore;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class DefaultCacheStore<K, V>
implements CacheStore<K, V> {
    private final ConcurrentMap<K, V> cache = new ConcurrentHashMap();

    @Override
    public V fetch(K key, Supplier<V> valueProvider) {
        if (!this.cache.containsKey(key)) {
            try {
                Object value = valueProvider.get();
                this.cache.put(key, value);
                return (V)value;
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e);
                throw new CacheException("Error computing the value", e);
            }
        }
        return this.cache.get(key);
    }

    @Override
    public V write(K key, V value) {
        return this.cache.put(key, value);
    }

    @Override
    public V fetch(K key) {
        return this.cache.get(key);
    }
}

