/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.controller;

import br.com.caelum.vraptor.controller.BeanClass;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.controller.DefaultBeanClass;
import br.com.caelum.vraptor.proxy.CDIProxies;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class DefaultControllerMethod
implements ControllerMethod {
    private final BeanClass controller;
    private final Method method;

    public DefaultControllerMethod(BeanClass controller, Method method) {
        this.controller = controller;
        this.method = method;
    }

    public static ControllerMethod instanceFor(Class<?> type, Method method) {
        type = CDIProxies.extractRawTypeIfPossible(type);
        return new DefaultControllerMethod(new DefaultBeanClass(type), method);
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public int getArity() {
        return this.method.getParameterTypes().length;
    }

    @Override
    public BeanClass getController() {
        return this.controller;
    }

    @Override
    public boolean containsAnnotation(Class<? extends Annotation> annotation) {
        return this.method.isAnnotationPresent(annotation);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.method.getAnnotations();
    }

    public String toString() {
        return "[DefaultControllerMethod: " + this.method + "]";
    }

    public int hashCode() {
        return Objects.hash(this.method, this.controller);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultControllerMethod other = (DefaultControllerMethod)obj;
        return Objects.equals(this.method, other.method) && Objects.equals(this.controller, other.controller);
    }
}

