/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.controller;

import br.com.caelum.vraptor.Delete;
import br.com.caelum.vraptor.Get;
import br.com.caelum.vraptor.Head;
import br.com.caelum.vraptor.Options;
import br.com.caelum.vraptor.Patch;
import br.com.caelum.vraptor.Post;
import br.com.caelum.vraptor.Put;
import br.com.caelum.vraptor.Trace;
import br.com.caelum.vraptor.controller.InvalidInputException;
import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;

public enum HttpMethod {
    GET(Get.class),
    POST(Post.class),
    PUT(Put.class),
    DELETE(Delete.class),
    TRACE(Trace.class),
    HEAD(Head.class),
    OPTIONS(Options.class),
    PATCH(Patch.class);

    private static final String METHOD_PARAMETER = "_method";
    private final Class<? extends Annotation> type;

    private HttpMethod(Class<? extends Annotation> type) {
        this.type = type;
    }

    public Class<? extends Annotation> getAnnotation() {
        return this.type;
    }

    public static HttpMethod of(HttpServletRequest request) {
        String methodName = request.getParameter(METHOD_PARAMETER);
        if (methodName == null) {
            methodName = request.getMethod();
        } else if ("GET".equalsIgnoreCase(request.getMethod())) {
            throw new InvalidInputException("You can't use _method parameter on a GET request. Use POST instead.");
        }
        try {
            return HttpMethod.valueOf(methodName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("HTTP Method not known: " + methodName, e);
        }
    }
}

