/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.converter.ConversionException;
import br.com.caelum.vraptor.converter.ConversionMessage;
import br.com.caelum.vraptor.converter.Converter;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;

@Alternative
@Priority(value=1000)
@Convert(value=BigDecimal.class)
public class BigDecimalConverter
implements Converter<BigDecimal> {
    private static final String INVALID_MESSAGE_KEY = "is_not_a_valid_number";
    private final Locale locale;

    protected BigDecimalConverter() {
        this(null);
    }

    @Inject
    public BigDecimalConverter(Locale locale) {
        this.locale = locale;
    }

    @Override
    public BigDecimal convert(String value, Class<? extends BigDecimal> type) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        try {
            return (BigDecimal)this.getNumberFormat().parse(value);
        }
        catch (ParseException e) {
            throw new ConversionException(new ConversionMessage(INVALID_MESSAGE_KEY, value));
        }
    }

    protected NumberFormat getNumberFormat() {
        DecimalFormat fmt = (DecimalFormat)DecimalFormat.getInstance(this.locale);
        fmt.setParseBigDecimal(true);
        return fmt;
    }
}

