/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter;

import br.com.caelum.vraptor.validator.I18nMessage;
import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.validator.Severity;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.util.ResourceBundle;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class ConversionMessage
implements Message {
    private static final long serialVersionUID = 1L;
    private final Message message;
    private String category;
    private final Severity severity;

    public ConversionMessage(String category, Message message) {
        this.message = message;
        this.category = category;
        this.severity = Severity.ERROR;
    }

    public ConversionMessage(String category, Message message, Severity severity) {
        this.message = message;
        this.category = category;
        this.severity = severity;
    }

    public ConversionMessage(String key, Object ... parameters) {
        this("", new I18nMessage("", key, parameters));
    }

    public ConversionMessage(String key, Severity severity, Object ... parameters) {
        this("", new I18nMessage("", key, parameters), severity);
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    public String getMessage() {
        return this.message.getMessage();
    }

    public Message withCategory(String category) {
        this.category = category;
        return this;
    }

    @Override
    public String getCategory() {
        return (String)Objects.firstNonNull((Object)Strings.emptyToNull((String)this.message.getCategory()), (Object)this.category);
    }

    @Override
    public void setBundle(ResourceBundle bundle) {
        this.message.setBundle(bundle);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("category", (Object)this.getCategory()).add("message", (Object)this.getMessage()).toString();
    }
}

