/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.converter.ConversionException;
import br.com.caelum.vraptor.converter.ConversionMessage;
import br.com.caelum.vraptor.converter.Converter;
import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;

@Convert(value=Double.class)
@Alternative
@Priority(value=1000)
public class DoubleConverter
implements Converter<Double> {
    public static final String INVALID_MESSAGE_KEY = "is_not_a_valid_number";
    private final Locale locale;

    protected DoubleConverter() {
        this(null);
    }

    @Inject
    public DoubleConverter(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Double convert(String value, Class<? extends Double> type) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        try {
            return this.getNumberFormat().parse(value).doubleValue();
        }
        catch (ParseException e) {
            throw new ConversionException(new ConversionMessage(INVALID_MESSAGE_KEY, value));
        }
    }

    protected NumberFormat getNumberFormat() {
        return DecimalFormat.getInstance(this.locale);
    }
}

