/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.converter.ConversionException;
import br.com.caelum.vraptor.converter.ConversionMessage;
import br.com.caelum.vraptor.converter.Converter;
import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.annotation.Priority;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;

@Convert(value=float.class)
@RequestScoped
@Alternative
@Priority(value=1000)
public class PrimitiveFloatConverter
implements Converter<Float> {
    public static final String INVALID_MESSAGE_KEY = "is_not_a_valid_number";
    private final Locale locale;

    protected PrimitiveFloatConverter() {
        this(null);
    }

    @Inject
    public PrimitiveFloatConverter(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Float convert(String value, Class<? extends Float> type) {
        if (Strings.isNullOrEmpty((String)value)) {
            return Float.valueOf(0.0f);
        }
        try {
            return Float.valueOf(this.getNumberFormat().parse(value).floatValue());
        }
        catch (ParseException e) {
            throw new ConversionException(new ConversionMessage(INVALID_MESSAGE_KEY, value));
        }
    }

    protected NumberFormat getNumberFormat() {
        return DecimalFormat.getInstance(this.locale);
    }
}

