/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.core.ExceptionMapper;
import br.com.caelum.vraptor.core.ExceptionRecorder;
import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.proxy.Proxifier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class DefaultExceptionMapper
implements ExceptionMapper {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionMapper.class);
    private final Map<Class<? extends Exception>, ExceptionRecorder<Result>> exceptions;
    private final Proxifier proxifier;
    private final ReflectionProvider reflectionProvider;

    protected DefaultExceptionMapper() {
        this(null, null);
    }

    @Inject
    public DefaultExceptionMapper(Proxifier proxifier, ReflectionProvider reflectionProvider) {
        this.proxifier = proxifier;
        this.reflectionProvider = reflectionProvider;
        this.exceptions = new LinkedHashMap<Class<? extends Exception>, ExceptionRecorder<Result>>();
    }

    @Override
    public Result record(Class<? extends Exception> exception) {
        Objects.requireNonNull(exception, "Exception cannot be null.");
        ExceptionRecorder instance = new ExceptionRecorder(this.proxifier, this.reflectionProvider);
        this.exceptions.put(exception, instance);
        return this.proxifier.proxify(Result.class, instance);
    }

    @Override
    public ExceptionRecorder<Result> findByException(Exception e) {
        logger.debug("find for exception {}", e.getClass());
        for (Map.Entry<Class<? extends Exception>, ExceptionRecorder<Result>> entry : this.exceptions.entrySet()) {
            if (!entry.getKey().isInstance(e)) continue;
            logger.debug("found exception mapping: {} -> {}", entry.getKey(), entry.getValue());
            return entry.getValue();
        }
        return DefaultExceptionMapper.hasExceptionCause(e) ? this.findByException((Exception)e.getCause()) : null;
    }

    private static boolean hasExceptionCause(Exception e) {
        return e.getCause() != null && e.getCause() instanceof Exception;
    }
}

