/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.controller.ControllerInstance;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.core.InterceptorHandler;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.core.InterceptorStackHandlersCache;
import br.com.caelum.vraptor.events.InterceptorsExecuted;
import br.com.caelum.vraptor.events.InterceptorsReady;
import java.util.Iterator;
import java.util.LinkedList;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class DefaultInterceptorStack
implements InterceptorStack {
    private static final Logger logger = LoggerFactory.getLogger(DefaultInterceptorStack.class);
    private final InterceptorStackHandlersCache cache;
    private final LinkedList<Iterator<InterceptorHandler>> internalStack = new LinkedList();
    private final Instance<ControllerMethod> controllerMethod;
    private final Instance<ControllerInstance> controllerInstance;
    private final Event<InterceptorsReady> interceptorsReadyEvent;
    private final Event<InterceptorsExecuted> interceptorsExecutedEvent;

    protected DefaultInterceptorStack() {
        this(null, null, null, null, null);
    }

    @Inject
    public DefaultInterceptorStack(InterceptorStackHandlersCache cache, Instance<ControllerMethod> controllerMethod, Instance<ControllerInstance> controllerInstance, Event<InterceptorsExecuted> event, Event<InterceptorsReady> stackStartingEvent) {
        this.cache = cache;
        this.controllerMethod = controllerMethod;
        this.controllerInstance = controllerInstance;
        this.interceptorsExecutedEvent = event;
        this.interceptorsReadyEvent = stackStartingEvent;
    }

    @Override
    public void next(ControllerMethod method, Object controllerInstance) throws InterceptionException {
        Iterator<InterceptorHandler> iterator = this.internalStack.peek();
        if (!iterator.hasNext()) {
            this.interceptorsExecutedEvent.fire((Object)new InterceptorsExecuted((ControllerMethod)this.controllerMethod.get(), controllerInstance));
            logger.debug("All registered interceptors have been called. End of VRaptor Request Execution.");
            return;
        }
        InterceptorHandler handler = iterator.next();
        handler.execute(this, method, controllerInstance);
    }

    @Override
    public void start() {
        ControllerMethod method = (ControllerMethod)this.controllerMethod.get();
        this.interceptorsReadyEvent.fire((Object)new InterceptorsReady(method));
        LinkedList<InterceptorHandler> handlers = this.cache.getInterceptorHandlers();
        this.internalStack.addFirst(handlers.iterator());
        this.next(method, ((ControllerInstance)this.controllerInstance.get()).getController());
        this.internalStack.poll();
    }
}

