/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.core.StaticContentHandler;
import br.com.caelum.vraptor.http.VRaptorRequest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultStaticContentHandler
implements StaticContentHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultStaticContentHandler.class);
    private final ServletContext context;

    protected DefaultStaticContentHandler() {
        this(null);
    }

    @Inject
    public DefaultStaticContentHandler(ServletContext context) {
        this.context = context;
    }

    @Override
    public boolean requestingStaticFile(HttpServletRequest request) throws MalformedURLException {
        URL resourceUrl = this.context.getResource(this.uriRelativeToContextRoot(request));
        return resourceUrl != null && DefaultStaticContentHandler.isAFile(resourceUrl);
    }

    private String uriRelativeToContextRoot(HttpServletRequest request) {
        String uri = VRaptorRequest.getRelativeRequestURI(request);
        return DefaultStaticContentHandler.removeQueryStringAndJSessionId(uri);
    }

    private static String removeQueryStringAndJSessionId(String uri) {
        if (uri.contains("?") || uri.contains(";")) {
            return uri.replaceAll("[\\?;].+", "");
        }
        return uri;
    }

    private static boolean isAFile(URL resourceUrl) {
        return !resourceUrl.toString().endsWith("/");
    }

    @Override
    public void deferProcessingToContainer(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug("Deferring request to container: {} ", (Object)request.getRequestURI());
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

