/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.core.ExceptionRecorderParameter;
import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.SuperMethod;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class ExceptionRecorder<T>
implements MethodInvocation<T> {
    private final List<ExceptionRecorderParameter> parameters = new ArrayList<ExceptionRecorderParameter>();
    private final Proxifier proxifier;
    private final ReflectionProvider reflectionProvider;

    public ExceptionRecorder(Proxifier proxifier, ReflectionProvider reflectionProvider) {
        this.proxifier = proxifier;
        this.reflectionProvider = reflectionProvider;
    }

    @Override
    public Object intercept(T proxy, Method method, Object[] args, SuperMethod superMethod) {
        this.parameters.add(new ExceptionRecorderParameter(args, method));
        if (Void.TYPE.equals(method.getReturnType())) {
            return null;
        }
        return this.proxifier.proxify(this.findReturnType(method, args), this);
    }

    private Class<?> findReturnType(Method method, Object[] args) {
        if (method.getGenericReturnType() instanceof TypeVariable) {
            if (args[0] instanceof Class) {
                return (Class)args[0];
            }
            return args[0].getClass();
        }
        return method.getReturnType();
    }

    public void replay(Result result) {
        Object current = result;
        for (ExceptionRecorderParameter p : this.parameters) {
            current = this.reflectionProvider.invoke(current, p.getMethod(), p.getArgs());
        }
    }
}

