/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.util.EmptyBundle;
import br.com.caelum.vraptor.util.SafeResourceBundle;
import com.google.common.base.Objects;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class JstlLocalization {
    private static final Logger logger = LoggerFactory.getLogger(JstlLocalization.class);
    private static final String DEFAULT_BUNDLE_NAME = "messages";
    private final HttpServletRequest request;

    protected JstlLocalization() {
        this(null);
    }

    @Inject
    public JstlLocalization(HttpServletRequest request) {
        this.request = request;
    }

    @Produces
    public ResourceBundle getBundle(Locale locale) {
        Object bundle = this.findByKey("javax.servlet.jsp.jstl.fmt.localizationContext");
        ResourceBundle unsafe = this.extractUnsafeBundle(bundle, locale);
        return new SafeResourceBundle(unsafe);
    }

    private ResourceBundle extractUnsafeBundle(Object bundle, Locale locale) {
        if (bundle instanceof String || bundle == null) {
            String baseName = (String)Objects.firstNonNull((Object)((String)bundle), (Object)DEFAULT_BUNDLE_NAME);
            try {
                return ResourceBundle.getBundle(baseName, locale);
            }
            catch (MissingResourceException e) {
                logger.warn("Couldn't find message bundle for base name '{}' and locale '{}', creating an empty one", (Object)baseName, (Object)locale);
                return new EmptyBundle();
            }
        }
        if (bundle instanceof LocalizationContext) {
            return ((LocalizationContext)bundle).getResourceBundle();
        }
        logger.warn("Can't handle bundle '{}'. Please report this bug. Using an empty bundle", bundle);
        return new EmptyBundle();
    }

    @Produces
    public Locale getLocale() {
        Locale localeFromConfig = this.localeFor("javax.servlet.jsp.jstl.fmt.locale");
        return (Locale)Objects.firstNonNull((Object)localeFromConfig, (Object)Locale.getDefault());
    }

    private Locale localeFor(String key) {
        Object localeValue = this.findByKey(key);
        if (localeValue instanceof String) {
            String languageTag = localeValue.toString().replace("_", "-");
            return Locale.forLanguageTag(languageTag);
        }
        if (localeValue instanceof Locale) {
            return (Locale)localeValue;
        }
        return this.request.getLocale();
    }

    private Object findByKey(String key) {
        Object value = Config.get((ServletRequest)this.request, (String)key);
        if (value != null) {
            return value;
        }
        value = Config.get((HttpSession)this.request.getSession(), (String)key);
        if (value != null) {
            return value;
        }
        value = Config.get((ServletContext)this.request.getServletContext(), (String)key);
        if (value != null) {
            return value;
        }
        return this.request.getServletContext().getInitParameter(key);
    }
}

