/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.events.ControllerFound;
import br.com.caelum.vraptor.http.Parameter;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.http.ValuedParameter;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;

@RequestScoped
public class MethodInfo {
    private final ParameterNameProvider parameterNameProvider;
    private ControllerMethod controllerMethod;
    private ValuedParameter[] valuedParameters;
    private Object result;

    protected MethodInfo() {
        this(null);
    }

    @Inject
    public MethodInfo(ParameterNameProvider parameterNameProvider) {
        this.parameterNameProvider = parameterNameProvider;
    }

    @Produces
    public ControllerMethod getControllerMethod() {
        return this.controllerMethod;
    }

    public void observeController(@Observes ControllerFound event) {
        this.setControllerMethod(event.getMethod());
    }

    public void setControllerMethod(ControllerMethod controllerMethod) {
        this.valuedParameters = null;
        this.controllerMethod = controllerMethod;
    }

    public ValuedParameter[] getValuedParameters() {
        this.createValuedParameter(this.controllerMethod);
        return this.valuedParameters;
    }

    public void setParameter(int index, Object value) {
        this.getValuedParameters()[index].setValue(value);
    }

    public Object[] getParametersValues() {
        Object[] out = new Object[this.getValuedParameters().length];
        for (int i = 0; i < this.getValuedParameters().length; ++i) {
            out[i] = this.getValuedParameters()[i].getValue();
        }
        return out;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    private void createValuedParameter(ControllerMethod controllerMethod) {
        if (this.valuedParameters == null) {
            this.valuedParameters = new ValuedParameter[controllerMethod.getArity()];
            if (controllerMethod != null && controllerMethod.getMethod() != null) {
                Parameter[] parameters = this.parameterNameProvider.parametersFor(controllerMethod.getMethod());
                for (int i = 0; i < this.valuedParameters.length; ++i) {
                    this.valuedParameters[i] = new ValuedParameter(parameters[i], null);
                }
            }
        }
    }
}

