/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.environment;

import br.com.caelum.vraptor.environment.Environment;
import br.com.caelum.vraptor.environment.EnvironmentType;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="environment")
public class DefaultEnvironment
implements Environment {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEnvironment.class);
    public static final String ENVIRONMENT_PROPERTY = "br.com.caelum.vraptor.environment";
    public static final String BASE_ENVIRONMENT_FILE = "environment";
    private final ServletContext context;
    private Properties properties;
    private EnvironmentType environmentType;

    protected DefaultEnvironment() {
        this((ServletContext)null);
    }

    @Inject
    public DefaultEnvironment(ServletContext context) {
        this.context = context;
    }

    public DefaultEnvironment(EnvironmentType environmentType) {
        this((ServletContext)null);
        this.environmentType = environmentType;
        this.loadProperties();
    }

    @PostConstruct
    protected void setup() {
        this.loadProperties();
    }

    private void loadProperties() {
        this.properties = new Properties();
        this.loadAndPut(BASE_ENVIRONMENT_FILE);
        this.loadAndPut(this.getEnvironmentType().getName());
        LOG.debug("Environment is up with properties {}", (Object)this.properties);
    }

    private EnvironmentType getEnvironmentType() {
        if (this.environmentType == null) {
            this.environmentType = new EnvironmentType(this.findEnvironmentName(this.context));
        }
        return this.environmentType;
    }

    private void loadAndPut(String environment) {
        try (InputStream resource = this.getClass().getResourceAsStream("/" + environment + ".properties");){
            this.properties.load(resource);
            LOG.debug("File {}.properties loaded", (Object)environment);
        }
        catch (IOException | NullPointerException whenNotFound) {
            LOG.warn("Could not find the file " + environment + ".properties to load.", (Throwable)whenNotFound);
        }
    }

    private String findEnvironmentName(ServletContext context) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String name = DefaultEnvironment.fromSystemEnv();
                if (name != null) {
                    LOG.debug("Environment {} loaded by system env", (Object)name);
                    return name;
                }
                name = DefaultEnvironment.fromSystemProperty();
                if (name != null) {
                    LOG.debug("Environment {} loaded by system property", (Object)name);
                    return name;
                }
                name = DefaultEnvironment.this.fromApplicationContext();
                if (name != null) {
                    LOG.debug("Environment {} loaded by web.xml", (Object)name);
                    return name;
                }
                LOG.debug("No enviroment was found, using development as default");
                return "development";
            }
        });
    }

    private static String fromSystemEnv() {
        return System.getenv("VRAPTOR_ENV");
    }

    private static String fromSystemProperty() {
        return System.getProperty(ENVIRONMENT_PROPERTY);
    }

    private String fromApplicationContext() {
        return this.context.getInitParameter(ENVIRONMENT_PROPERTY);
    }

    @Override
    public boolean supports(String feature) {
        if (this.has(feature)) {
            return Boolean.parseBoolean(this.get(feature).trim());
        }
        return false;
    }

    @Override
    public boolean has(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public String get(String key) {
        if (!this.has(key)) {
            throw new NoSuchElementException(String.format("Key %s not found in environment %s", key, this.getName()));
        }
        String systemProperty = System.getProperty(key);
        if (!Strings.isNullOrEmpty((String)systemProperty)) {
            return systemProperty;
        }
        return this.properties.getProperty(key);
    }

    @Override
    public String get(String key, String defaultValue) {
        if (this.has(key)) {
            return this.get(key);
        }
        return defaultValue;
    }

    @Override
    public void set(String key, String value) {
        this.properties.setProperty(key, value);
    }

    @Override
    public Iterable<String> getKeys() {
        return this.properties.stringPropertyNames();
    }

    @Override
    public boolean isProduction() {
        return EnvironmentType.PRODUCTION.equals(this.getEnvironmentType());
    }

    @Override
    public boolean isDevelopment() {
        return EnvironmentType.DEVELOPMENT.equals(this.getEnvironmentType());
    }

    @Override
    public boolean isTest() {
        return EnvironmentType.TEST.equals(this.getEnvironmentType());
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.getClass().getResource("/" + this.getEnvironmentType().getName() + name);
        if (resource != null) {
            LOG.debug("Loading resource {} from environment {}", (Object)name, (Object)this.getEnvironmentType().getName());
            return resource;
        }
        return this.getClass().getResource(name);
    }

    @Override
    public String getName() {
        return this.getEnvironmentType().getName();
    }
}

