/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http;

import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.controller.HttpMethod;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.UrlToControllerTranslator;
import br.com.caelum.vraptor.http.route.MethodNotAllowedException;
import br.com.caelum.vraptor.http.route.Router;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultControllerTranslator
implements UrlToControllerTranslator {
    private final Logger logger = LoggerFactory.getLogger(DefaultControllerTranslator.class);
    private final Router router;

    protected DefaultControllerTranslator() {
        this(null);
    }

    @Inject
    public DefaultControllerTranslator(Router router) {
        this.router = router;
    }

    @Override
    public ControllerMethod translate(MutableRequest request) {
        String controllerName = request.getRequestedUri();
        this.logger.debug("trying to access {}", (Object)controllerName);
        HttpMethod method = this.getHttpMethod(request, controllerName);
        ControllerMethod controller = this.router.parse(controllerName, method, request);
        this.logger.debug("found controller {}", (Object)controller);
        return controller;
    }

    private HttpMethod getHttpMethod(MutableRequest request, String controllerName) {
        try {
            return HttpMethod.of(request);
        }
        catch (IllegalArgumentException e) {
            throw new MethodNotAllowedException(this.router.allowedMethodsFor(controllerName), request.getMethod());
        }
    }
}

