/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http;

import br.com.caelum.vraptor.VRaptorException;
import com.google.common.base.Objects;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ApplicationScoped
public class EncodingHandler {
    public static final String ENCODING_KEY = "br.com.caelum.vraptor.encoding";
    private String encoding;
    private final ServletContext context;

    protected EncodingHandler() {
        this(null);
    }

    @Inject
    public EncodingHandler(ServletContext context) {
        this.context = context;
    }

    @PostConstruct
    public void init() {
        this.encoding = this.context.getInitParameter(ENCODING_KEY);
        this.encoding = (String)Objects.firstNonNull((Object)this.encoding, (Object)Charset.defaultCharset().name());
    }

    public void setEncoding(HttpServletRequest request, HttpServletResponse response) {
        try {
            request.setCharacterEncoding(this.getEncoding());
            response.setCharacterEncoding(this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new VRaptorException(e);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }
}

