/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class Parameter {
    private final int index;
    private final String name;
    private final AccessibleObject holder;
    private final Type parameterizedType;
    private final Class<?> parameterType;
    private final Annotation[] annotations;

    public Parameter(int index, String name, AccessibleObject holder) {
        this.index = index;
        this.name = name;
        this.holder = holder;
        if (holder instanceof Method) {
            Method method = (Method)holder;
            this.parameterizedType = method.getGenericParameterTypes()[index];
            this.parameterType = method.getParameterTypes()[index];
            this.annotations = method.getParameterAnnotations()[index];
        } else if (holder instanceof Constructor) {
            Constructor constr = (Constructor)holder;
            this.parameterizedType = constr.getGenericParameterTypes()[index];
            this.parameterType = constr.getParameterTypes()[index];
            this.annotations = constr.getParameterAnnotations()[index];
        } else {
            throw new UnsupportedOperationException("We can only evaluate methods or constructors " + holder.getClass());
        }
    }

    public String getName() {
        return this.name;
    }

    public Type getParameterizedType() {
        return this.parameterizedType;
    }

    public Class<?> getType() {
        return this.parameterType;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.getAnnotation(clazz) != null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        for (Annotation a : this.getDeclaredAnnotations()) {
            if (!a.annotationType().equals(clazz)) continue;
            return (T)((Annotation)clazz.cast(a));
        }
        return null;
    }

    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.annotations;
    }

    public boolean equals(Object obj) {
        if (this.getClass() == obj.getClass()) {
            Parameter other = (Parameter)obj;
            return other.index == this.index && other.holder.equals(this.holder);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.holder);
    }
}

