/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http;

import br.com.caelum.vraptor.http.Parameter;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import com.thoughtworks.paranamer.AnnotationParanamer;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.ParameterNamesNotFoundException;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.reflect.AccessibleObject;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Priority(value=1010)
public class ParanamerNameProvider
implements ParameterNameProvider {
    private static final Logger logger = LoggerFactory.getLogger(ParanamerNameProvider.class);
    private final Paranamer info = new CachingParanamer((Paranamer)new AnnotationParanamer((Paranamer)new BytecodeReadingParanamer()));

    @Override
    public Parameter[] parametersFor(AccessibleObject executable) {
        try {
            String[] names = this.info.lookupParameterNames(executable);
            Parameter[] params = new Parameter[names.length];
            logger.debug("Found parameter names with paranamer for {} as {}", (Object)executable, (Object)names);
            for (int i = 0; i < names.length; ++i) {
                params[i] = new Parameter(i, names[i], executable);
            }
            return this.defensiveCopy(params);
        }
        catch (ParameterNamesNotFoundException e) {
            throw new IllegalStateException("Paranamer were not able to find your parameter names for " + executable + "You must compile your code with debug information (javac -g), or using @Named on each method parameter.", e);
        }
    }

    private Parameter[] defensiveCopy(Parameter[] src) {
        Parameter[] copy = new Parameter[src.length];
        System.arraycopy(src, 0, copy, 0, src.length);
        return copy;
    }
}

