/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.iogi;

import br.com.caelum.iogi.parameters.Parameters;
import br.com.caelum.iogi.reflection.Target;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.http.Parameter;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.http.ParametersProvider;
import br.com.caelum.vraptor.http.iogi.InstantiatorWithErrors;
import br.com.caelum.vraptor.validator.Message;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class IogiParametersProvider
implements ParametersProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(IogiParametersProvider.class);
    private final ParameterNameProvider nameProvider;
    private final HttpServletRequest servletRequest;
    private final InstantiatorWithErrors instantiator;

    protected IogiParametersProvider() {
        this(null, null, null);
    }

    @Inject
    public IogiParametersProvider(ParameterNameProvider provider, HttpServletRequest parameters, InstantiatorWithErrors instantiator) {
        this.nameProvider = provider;
        this.servletRequest = parameters;
        this.instantiator = instantiator;
        LOGGER.debug("IogiParametersProvider is up");
    }

    @Override
    public Object[] getParametersFor(ControllerMethod method, List<Message> errors) {
        Parameters parameters = this.parseParameters(this.servletRequest);
        List<Target<Object>> targets = this.createTargets(method);
        return this.instantiateParameters(parameters, targets, errors).toArray();
    }

    private List<Object> instantiateParameters(Parameters parameters, List<Target<Object>> targets, List<Message> errors) {
        LOGGER.debug("getParametersFor() called with parameters {} and targets {}.", (Object)parameters, targets);
        ArrayList<Object> arguments = new ArrayList<Object>(targets.size());
        for (Target<Object> target : targets) {
            Object newObject = this.instantiateOrAddError(parameters, errors, target);
            arguments.add(newObject);
        }
        return arguments;
    }

    private Object instantiateOrAddError(Parameters parameters, List<Message> errors, Target<Object> target) {
        return this.instantiator.instantiate(target, parameters, errors);
    }

    private List<Target<Object>> createTargets(ControllerMethod method) {
        Method javaMethod = method.getMethod();
        ArrayList<Target<Object>> targets = new ArrayList<Target<Object>>();
        for (Parameter p : this.nameProvider.parametersFor(javaMethod)) {
            Type type = p.getParameterizedType();
            if (type instanceof TypeVariable) {
                type = this.extractType(method, (TypeVariable)type);
            }
            targets.add((Target<Object>)new Target(type, p.getName()));
        }
        return targets;
    }

    private Type extractType(ControllerMethod method, TypeVariable<?> paramType) {
        ParameterizedType parameterizedType = (ParameterizedType)method.getController().getType().getGenericSuperclass();
        Class rawType = (Class)parameterizedType.getRawType();
        TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
        if (typeParameters.length > 0) {
            for (int i = 0; i < typeParameters.length; ++i) {
                TypeVariable typeVariable = typeParameters[i];
                if (!typeVariable.getName().equals(paramType.getName())) continue;
                return (Class)parameterizedType.getActualTypeArguments()[i];
            }
        }
        return paramType;
    }

    private Parameters parseParameters(HttpServletRequest request) {
        Map parameters = request.getParameterMap();
        ArrayList<br.com.caelum.iogi.parameters.Parameter> parameterList = new ArrayList<br.com.caelum.iogi.parameters.Parameter>(parameters.size() * 2);
        for (Map.Entry param : parameters.entrySet()) {
            for (String value : (String[])param.getValue()) {
                parameterList.add(new br.com.caelum.iogi.parameters.Parameter((String)param.getKey(), value));
            }
        }
        return new Parameters(parameterList);
    }
}

