/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.iogi;

import br.com.caelum.iogi.Instantiator;
import br.com.caelum.iogi.MultiInstantiator;
import br.com.caelum.iogi.ObjectInstantiator;
import br.com.caelum.iogi.collections.ArrayInstantiator;
import br.com.caelum.iogi.collections.ListInstantiator;
import br.com.caelum.iogi.conversion.FallbackConverter;
import br.com.caelum.iogi.conversion.StringConverter;
import br.com.caelum.iogi.conversion.TypeConverter;
import br.com.caelum.iogi.parameters.Parameter;
import br.com.caelum.iogi.parameters.Parameters;
import br.com.caelum.iogi.reflection.NewObject;
import br.com.caelum.iogi.reflection.Target;
import br.com.caelum.iogi.spi.DependencyProvider;
import br.com.caelum.iogi.spi.ParameterNamesProvider;
import br.com.caelum.vraptor.converter.ConversionException;
import br.com.caelum.vraptor.converter.Converter;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.http.InvalidParameterException;
import br.com.caelum.vraptor.http.iogi.ArrayAdapter;
import br.com.caelum.vraptor.http.iogi.InstantiatorWithErrors;
import br.com.caelum.vraptor.http.iogi.NullDecorator;
import br.com.caelum.vraptor.http.iogi.RequestAttributeInstantiator;
import br.com.caelum.vraptor.http.iogi.SetInstantiator;
import br.com.caelum.vraptor.validator.Message;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class VRaptorInstantiator
implements InstantiatorWithErrors,
Instantiator<Object> {
    private static final Logger logger = LoggerFactory.getLogger(VRaptorInstantiator.class);
    private MultiInstantiator multiInstantiator;
    private List<Message> errors;
    private final Converters converters;
    private final DependencyProvider provider;
    private final ParameterNamesProvider parameterNameProvider;
    private final HttpServletRequest request;

    protected VRaptorInstantiator() {
        this(null, null, null, null);
    }

    @Inject
    public VRaptorInstantiator(Converters converters, DependencyProvider provider, ParameterNamesProvider parameterNameProvider, HttpServletRequest request) {
        this.converters = converters;
        this.provider = provider;
        this.parameterNameProvider = parameterNameProvider;
        this.request = request;
    }

    @PostConstruct
    public void createInstantiator() {
        Object objectInstantiator = new ObjectInstantiator((Instantiator)this, this.provider, this.parameterNameProvider);
        if (this.useNullForMissingParameters()) {
            objectInstantiator = new NullDecorator((Instantiator<?>)objectInstantiator);
        }
        ImmutableList instantiatorList = ImmutableList.of((Object)new RequestAttributeInstantiator(this.request), (Object)new VRaptorTypeConverter(this.converters), (Object)FallbackConverter.fallbackToNull((TypeConverter)new StringConverter()), (Object)new ArrayAdapter(new ArrayInstantiator((Instantiator)this)), (Object)new NullDecorator((Instantiator<?>)new ListInstantiator((Instantiator)this)), (Object)new NullDecorator(new SetInstantiator(this)), (Object)new DependencyInstantiator(), (Object)objectInstantiator);
        this.multiInstantiator = new MultiInstantiator((Collection)instantiatorList);
    }

    protected boolean useNullForMissingParameters() {
        return false;
    }

    public boolean isAbleToInstantiate(Target<?> target) {
        return true;
    }

    @Override
    public Object instantiate(Target<?> target, Parameters parameters, List<Message> errors) {
        this.errors = errors;
        return this.instantiate(target, parameters);
    }

    public Object instantiate(Target<?> target, Parameters parameters) {
        try {
            return this.multiInstantiator.instantiate(target, parameters);
        }
        catch (Exception e) {
            this.handleException(target, e);
            return null;
        }
    }

    private void handleException(Target<?> target, Throwable e) {
        if (e.getCause() == null) {
            throw new InvalidParameterException("Exception when trying to instantiate " + target, e);
        }
        this.handleException(target, e.getCause());
    }

    private final class VRaptorTypeConverter
    implements Instantiator<Object> {
        private final Converters converters;

        public VRaptorTypeConverter(Converters converters) {
            this.converters = converters;
        }

        public boolean isAbleToInstantiate(Target<?> target) {
            return this.converters.existsFor(target.getClassType());
        }

        public Object instantiate(Target<?> target, Parameters parameters) {
            try {
                if (this.isSupportedCollection(target)) {
                    return VRaptorInstantiator.this.multiInstantiator.instantiate(target, parameters);
                }
                Parameter parameter = parameters.namedAfter(target);
                return this.converterForTarget(target).convert(parameter.getValue(), target.getClassType());
            }
            catch (ConversionException ex) {
                logger.debug("Could not convert target", (Throwable)ex);
                VRaptorInstantiator.this.errors.add(ex.getValidationMessage().withCategory(target.getName()));
            }
            catch (IllegalStateException e) {
                logger.debug("An error occured while getting validation message", (Throwable)e);
                return this.setPropertiesAfterConversions(target, parameters);
            }
            return null;
        }

        private boolean isSupportedCollection(Target<?> target) {
            return List.class.isAssignableFrom(target.getClassType()) || Set.class.isAssignableFrom(target.getClassType()) || Map.class.isAssignableFrom(target.getClassType());
        }

        private Object setPropertiesAfterConversions(Target<?> target, Parameters parameters) {
            List params = parameters.forTarget(target);
            Parameter parameter = this.findParamFor(params, target);
            Object converted = this.converterForTarget(target).convert(parameter == null ? null : parameter.getValue(), target.getClassType());
            return new NewObject((Instantiator)this, parameters.focusedOn(target), converted).valueWithPropertiesSet();
        }

        private Parameter findParamFor(List<Parameter> params, Target<?> target) {
            for (Parameter parameter : params) {
                if (!parameter.getName().equals(target.getName())) continue;
                return parameter;
            }
            return null;
        }

        private Converter<Object> converterForTarget(Target<?> target) {
            return this.converters.to(target.getClassType());
        }
    }

    private final class DependencyInstantiator
    implements Instantiator<Object> {
        private DependencyInstantiator() {
        }

        public Object instantiate(Target<?> target, Parameters params) {
            return VRaptorInstantiator.this.provider.provide(target);
        }

        public boolean isAbleToInstantiate(Target<?> target) {
            return target.getClassType().isInterface() && VRaptorInstantiator.this.provider.canProvide(target);
        }
    }
}

