/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.Accepts;
import br.com.caelum.vraptor.AfterCall;
import br.com.caelum.vraptor.AroundCall;
import br.com.caelum.vraptor.BeforeCall;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.core.InterceptorHandler;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.interceptor.CustomAcceptsExecutor;
import br.com.caelum.vraptor.interceptor.CustomAcceptsFailCallback;
import br.com.caelum.vraptor.interceptor.InterceptorAcceptsExecutor;
import br.com.caelum.vraptor.interceptor.InterceptorExecutor;
import br.com.caelum.vraptor.interceptor.StepInvoker;
import br.com.caelum.vraptor.ioc.Container;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import javax.enterprise.inject.Vetoed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Vetoed
public class AspectStyleInterceptorHandler
implements InterceptorHandler {
    private static final Logger logger = LoggerFactory.getLogger(AspectStyleInterceptorHandler.class);
    private final StepInvoker stepInvoker;
    private final Container container;
    private final Class<?> interceptorClass;
    private final CustomAcceptsExecutor customAcceptsExecutor;
    private final InterceptorAcceptsExecutor acceptsExecutor;
    private final InterceptorExecutor interceptorExecutor;
    private Method afterMethod;
    private Method aroundMethod;
    private Method beforeMethod;
    private Method acceptsMethod;
    private Method customAcceptsMethod;

    public AspectStyleInterceptorHandler(Class<?> interceptorClass, StepInvoker stepInvoker, Container container, CustomAcceptsExecutor customAcceptsExecutor, InterceptorAcceptsExecutor acceptsExecutor, InterceptorExecutor interceptorExecutor) {
        this.interceptorClass = interceptorClass;
        this.stepInvoker = stepInvoker;
        this.container = container;
        this.customAcceptsExecutor = customAcceptsExecutor;
        this.acceptsExecutor = acceptsExecutor;
        this.interceptorExecutor = interceptorExecutor;
        this.extractAllInterceptorMethods();
    }

    private void extractAllInterceptorMethods() {
        List<Method> methods = this.stepInvoker.findAllMethods(this.interceptorClass);
        this.afterMethod = this.findMethodWith(AfterCall.class, methods);
        this.aroundMethod = this.findMethodWith(AroundCall.class, methods);
        this.beforeMethod = this.findMethodWith(BeforeCall.class, methods);
        this.acceptsMethod = this.findMethodWith(Accepts.class, methods);
        this.customAcceptsMethod = this.findMethodWith(CustomAcceptsFailCallback.class, methods);
    }

    @Override
    public void execute(InterceptorStack stack, ControllerMethod controllerMethod, Object currentController) {
        Object interceptor = this.container.instanceFor(this.interceptorClass);
        logger.debug("Invoking interceptor {}", (Object)interceptor.getClass().getSimpleName());
        List<Annotation> customAccepts = this.customAcceptsExecutor.getCustomAccepts(interceptor);
        if (this.customAccepts(interceptor, customAccepts) || this.internalAccepts(interceptor, customAccepts)) {
            this.interceptorExecutor.execute(interceptor, this.beforeMethod);
            this.interceptorExecutor.executeAround(interceptor, this.aroundMethod);
            this.interceptorExecutor.execute(interceptor, this.afterMethod);
        } else {
            stack.next(controllerMethod, currentController);
        }
    }

    private Method findMethodWith(Class<? extends Annotation> step, List<Method> methods) {
        return this.stepInvoker.findMethod(methods, step, this.interceptorClass);
    }

    private boolean internalAccepts(Object interceptor, List<Annotation> customAccepts) {
        if (!customAccepts.isEmpty()) {
            return false;
        }
        return this.acceptsExecutor.accepts(interceptor, this.acceptsMethod);
    }

    private boolean customAccepts(Object interceptor, List<Annotation> customAccepts) {
        return this.customAcceptsExecutor.accepts(interceptor, this.customAcceptsMethod, customAccepts);
    }

    public String toString() {
        return "AspectStyleInterceptorHandler for " + this.interceptorClass.getName();
    }
}

