/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.controller.ControllerInstance;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.interceptor.CustomAcceptsVerifier;
import br.com.caelum.vraptor.interceptor.StepInvoker;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@ApplicationScoped
public class CustomAcceptsExecutor {
    private final Instance<ControllerMethod> controllerMethod;
    private final Instance<ControllerInstance> controllerInstance;
    private final StepInvoker invoker;
    private final CustomAcceptsVerifier acceptsVerifier;

    protected CustomAcceptsExecutor() {
        this(null, null, null, null);
    }

    @Inject
    public CustomAcceptsExecutor(Instance<ControllerMethod> controllerMethod, Instance<ControllerInstance> controllerInstance, StepInvoker invoker, CustomAcceptsVerifier acceptsVerifier) {
        this.controllerMethod = controllerMethod;
        this.controllerInstance = controllerInstance;
        this.invoker = invoker;
        this.acceptsVerifier = acceptsVerifier;
    }

    public boolean accepts(Object interceptor, Method method, List<Annotation> constraints) {
        if (constraints.isEmpty()) {
            return false;
        }
        boolean customAccepts = this.acceptsVerifier.isValid(interceptor, (ControllerMethod)this.controllerMethod.get(), (ControllerInstance)this.controllerInstance.get(), constraints);
        if (!customAccepts) {
            this.invoker.tryToInvoke(interceptor, method, new Object[0]);
        }
        return customAccepts;
    }

    public List<Annotation> getCustomAccepts(Object interceptor) {
        return CustomAcceptsVerifier.getCustomAcceptsAnnotations(interceptor.getClass());
    }
}

