/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.core.ExceptionMapper;
import br.com.caelum.vraptor.core.ExceptionRecorder;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.interceptor.Interceptor;
import com.google.common.base.Throwables;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts
@RequestScoped
public class ExceptionHandlerInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHandlerInterceptor.class);
    private final ExceptionMapper exceptions;
    private final Result result;

    protected ExceptionHandlerInterceptor() {
        this(null, null);
    }

    @Inject
    public ExceptionHandlerInterceptor(ExceptionMapper exceptions, Result result) {
        this.exceptions = exceptions;
        this.result = result;
    }

    @Override
    public boolean accepts(ControllerMethod method) {
        return true;
    }

    @Override
    public void intercept(InterceptorStack stack, ControllerMethod method, Object controllerInstance) throws InterceptionException {
        block2: {
            try {
                stack.next(method, controllerInstance);
            }
            catch (InterceptionException e) {
                if (e.getCause() instanceof Exception && this.replay((Exception)e.getCause())) break block2;
                throw e;
            }
        }
    }

    protected void reportException(Exception e) {
        this.result.include("exception", Throwables.getRootCause((Throwable)e));
    }

    protected boolean replay(Exception e) {
        ExceptionRecorder<Result> exresult = this.exceptions.findByException(e);
        if (exresult == null) {
            return false;
        }
        this.reportException(e);
        logger.debug("handling exception {}", e.getClass(), (Object)e);
        exresult.replay(this.result);
        return true;
    }
}

